/**
 * Project Name:qiho-center-api
 * File Name:ItemStatusEnum.java
 * Package Name:com.qiho.center.api.enums
 * Date:2017年5月22日上午10:05:27
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/
/**
 * Project Name:qiho-center-api
 * File Name:ItemStatusEnum.java
 * Package Name:com.qiho.center.api.enums
 * Date:2017年5月22日上午10:05:27
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
 */

package com.qiho.center.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * ClassName:ItemStatusEnum <br/>
 * Date:     2017年5月22日 上午10:05:27 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
/**
 * ClassName: ItemStatusEnum <br/>
 * date: 2017年5月22日 上午10:05:27 <br/>
 *
 * @author zhanglihui
 * @version 
 * 
 */
public enum ItemStatusEnum {
    /** 商品上架 */
    STATUS_ON("ON", "上架"),
    
    /** 商品下架 */
    STATUS_OFF("OFF", "下架");
    
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    private ItemStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 
     * getByCode:(这里用一句话描述这个方法的作用). <br/>
     * 
     * @param code
     * @return DatabaseSchema
     */
    public static ItemStatusEnum getByCode(String code) {
        for (ItemStatusEnum enumVal : ItemStatusEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    /**
     *
     * @return code
     */
    public String getCode() {
        return code;
    }

    /**
     *
     * @return desc
     */
    public String getDesc() {
        return desc;
    }
}

