package com.qiho.center.api.enums.account;

import java.util.Arrays;

/**
 * Created by sunchangji on 2017/12/7.
 */
public enum BaiqiAccountStatusEnum {
    DISABLE(0,"禁用"),
    ENABLE(1,"启用");

    BaiqiAccountStatusEnum(int code,String desc){
        this.code = code;
        this.desc = desc;
    }

    private int code;
    private String desc;

    /**
     * 根据code查询
     *
     * @param code
     * @return
     */
    public static BaiqiAccountStatusEnum findByCode(Integer code){
        if(code == null){
            return null;
        }
        return Arrays.stream(BaiqiAccountStatusEnum.values()).filter(e -> e.getCode() == code).findFirst().orElse(null);
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
