package com.qiho.center.api.params.trading.record;

import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.enums.trading.statistics.CloseStatusEnum;
import com.qiho.center.api.params.ShopCustomPageParams;
import lombok.Data;
import lombok.ToString;

/**
 * @author Wangpf
 * @description
 * @date 2020/9/2 10:02 上午
 */
@Data
@ToString
public class ShopTradingRecordPageParam extends ShopCustomPageParams {

    /**
     * 商品Id
     */
    private Long itemId;

    /**
     * 支付类型 {@link PayTypeEnum}
     */
    private String payType;

    /**
     * 结算状态 {@link CloseStatusEnum}
     */
    private Integer closeStatus;

    /**
     * 订单的结算时间
     */
    private String closeTime;

    /**
     * 订单的创建时间
     */
    private String orderCreateTime;

    /**
     * 订单状态
     */
    private String orderStatus;

    /**
     * 订单未结算的原因
     */
    private Integer notCloseReason;
}
