package com.qiho.center.api.remoteservice.order;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.needsync.cancelledorder.CancelledOrderDto;
import com.qiho.center.api.dto.needsync.cancelledorder.PaginationDto;
import com.qiho.center.api.params.needsync.cancelledorder.BatchAlterParams;
import com.qiho.center.api.params.needsync.cancelledorder.EnrolmentCancelledOrderParams;
import com.qiho.center.api.params.needsync.cancelledorder.GainConditionParams;
import com.qiho.center.api.params.needsync.cancelledorder.GainPagingParams;
import java.util.List;

/**
 * { Remote } 需要同步·取消订单 Service Interface.
 * @dateTime 2020-08-05 11:51:27
 * @author haitao.hua
 */
@AdvancedFeignClient
public interface RemoteNeedSyncCancelledOrderService {


    /**
     * 登记·取消订单
     * @param record 取消订单
     * @return 处理结果
     */
    int enrolment(EnrolmentCancelledOrderParams record);

    /**
     * 批量变更·操作人
     * @param params 变更·入参
     * @return 处理结果
     */
    int batchAlterOperatorByCondition(BatchAlterParams params);

    /**
     * 全部查询·条件
     * @param condition 查询·条件
     * @return 处理结果
     */
    List<CancelledOrderDto> wholeByCondition(GainConditionParams condition);

    /**
     * 分页查询·条件
     * @param condition 查询·条件
     * @return 处理结果
     */
    PaginationDto<CancelledOrderDto> paginationByCondition(GainPagingParams condition);

}
