package com.qiho.center.api.remoteservice.tag;

import java.util.List;

import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.tag.TagDto;
import com.qiho.center.api.params.tag.TagPageParam;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author chensong
 * @create 2018-03-23 09:46
 **/
@AdvancedFeignClient
public interface RemoteTagService {

    /**
     * 新增或修改标签
     * @param tagDto
     * @return
     */
    ResultDto<Boolean> saveTag(TagDto tagDto);

    /**
     * 删除标签
     * @param tagId
     * @return
     */
    Boolean delete(Long tagId);

    /**
     * 根据标签类型id获取标签
     * @param typeId
     * @return
     */
    List<TagDto> findByTypeId(Long typeId);

    /**
     * 分页查询标签
     * @param param
     * @return
     */
    PagenationDto<TagDto> queryPage(TagPageParam param);

    /**
     * 根据itemId查找商品关联的标签
     * @param itemId
     * @return
     */
    List<TagDto> findByItemId(Long itemId);

    /**
     * 保存商品标签关系
     * @param itemId
     * @param tagIds
     * @return
     */
    ResultDto<Boolean> saveItemTag(Long itemId, List<Long> tagIds);

    /**
     * 根据商品idlist批量删除
     * @param itemIdList
     * @return
     */
    Boolean deleteByItemIdList(List<Long> itemIdList);

    /**
     * 根据商品id集合获取标签集合
     * @param itemIdList 商品ID集合
     * @return List<TagDto>
     */
    List<TagDto> findByItemIds(List<Long> itemIdList);
}
