package com.qiho.center.api.constant;

/**
 * 封装支付宝支付相关常量
 *
 * @author chensong
 * @create 2017-07-21 14:25
 **/
public class AliPayConstant {

    /**
     * 支付宝客户端请求响应码
     */
    public final class ResponseCode {

        private ResponseCode(){}

        public static final  String SUCCESS                    = "10000"; // 成功
        public static final String SERVER_UNAVAILABLE         = "20000"; // 服务不可用
        public static final String INVALID_PERMISSION         = "20001"; // 授权权限不足
        public static final String LACK_PARAM                 = "40001"; // 缺少必要参数
        public static final String ILLEGAL_PARAM              = "40002"; // 非法参数
        public static final  String PROCESSING_FAILED          = "40004"; // 业务处理失败
        public static final  String ACCOUNT_INVALID_PERMISSION = "40006"; // 账户授权不足
    }

    /**
     * 支付宝支付状态(异步通知)
     */
    public final class TradeStatus {

        private TradeStatus(){}

        public static final String TRADE_SUCCESS  = "TRADE_SUCCESS"; // 交易支付成功(会触发通知)
        public static final String WAIT_BUYER_PAY = "WAIT_BUYER_PAY"; // 交易创建，等待买家付款（不会触发通知）
        public static final String TRADE_FINISHED = "TRADE_FINISHED"; // 交易结束，不可退款（不会触发通知）
        public static final String TRADE_CLOSED   = "TRADE_CLOSED";  // 未付款交易超时关闭，或支付完成后全额退款（会触发通知）
    }

}
