package com.qiho.center.api.enums.area.code;

import com.qiho.center.api.enums.area.AreaCodeEnumerable;

import java.util.Arrays;

public enum AreaCodeJXEnum implements AreaCodeEnumerable {
    CODE_360000("360000", "江西省"),
    CODE_360100("360100", "江西省南昌市"),
    CODE_360101("360101", "江西省南昌市市辖区"),
    CODE_360102("360102", "江西省南昌市东湖区"),
    CODE_360103("360103", "江西省南昌市西湖区"),
    CODE_360104("360104", "江西省南昌市青云谱区"),
    CODE_360105("360105", "江西省南昌市湾里区"),
    CODE_360111("360111", "江西省南昌市郊区"),
    CODE_360121("360121", "江西省南昌市南昌县"),
    CODE_360122("360122", "江西省南昌市新建县"),
    CODE_360123("360123", "江西省南昌市安义县"),
    CODE_360124("360124", "江西省南昌市进贤县"),
    CODE_360200("360200", "江西省景德镇市"),
    CODE_360201("360201", "江西省景德镇市市辖区"),
    CODE_360202("360202", "江西省景德镇市昌江区"),
    CODE_360203("360203", "江西省景德镇市珠山区"),
    CODE_360222("360222", "江西省景德镇市浮梁县"),
    CODE_360281("360281", "江西省景德镇市乐平市"),
    CODE_360300("360300", "江西省萍乡市"),
    CODE_360301("360301", "江西省萍乡市市辖区"),
    CODE_360302("360302", "江西省萍乡市安源区"),
    CODE_360313("360313", "江西省萍乡市湘东区"),
    CODE_360321("360321", "江西省萍乡市莲花县"),
    CODE_360322("360322", "江西省萍乡市上栗县"),
    CODE_360323("360323", "江西省萍乡市芦溪县"),
    CODE_360400("360400", "江西省九江市"),
    CODE_360401("360401", "江西省九江市市辖区"),
    CODE_360402("360402", "江西省九江市庐山区"),
    CODE_360403("360403", "江西省九江市浔阳区"),
    CODE_360421("360421", "江西省九江市九江县"),
    CODE_360423("360423", "江西省九江市武宁县"),
    CODE_360424("360424", "江西省九江市修水县"),
    CODE_360425("360425", "江西省九江市永修县"),
    CODE_360426("360426", "江西省九江市德安县"),
    CODE_360427("360427", "江西省九江市星子县"),
    CODE_360428("360428", "江西省九江市都昌县"),
    CODE_360429("360429", "江西省九江市湖口县"),
    CODE_360430("360430", "江西省九江市彭泽县"),
    CODE_360481("360481", "江西省九江市瑞昌市"),
    CODE_360500("360500", "江西省新余市"),
    CODE_360501("360501", "江西省新余市市辖区"),
    CODE_360502("360502", "江西省新余市渝水区"),
    CODE_360521("360521", "江西省新余市分宜县"),
    CODE_360600("360600", "江西省鹰潭市"),
    CODE_360601("360601", "江西省鹰潭市市辖区"),
    CODE_360602("360602", "江西省鹰潭市月湖区"),
    CODE_360622("360622", "江西省鹰潭市余江县"),
    CODE_360681("360681", "江西省鹰潭市贵溪市"),
    CODE_360700("360700", "江西省赣州市"),
    CODE_360701("360701", "江西省赣州市市辖区"),
    CODE_360702("360702", "江西省赣州市章贡区"),
    CODE_360721("360721", "江西省赣州市赣县"),
    CODE_360722("360722", "江西省赣州市信丰县"),
    CODE_360723("360723", "江西省赣州市大余县"),
    CODE_360724("360724", "江西省赣州市上犹县"),
    CODE_360725("360725", "江西省赣州市崇义县"),
    CODE_360726("360726", "江西省赣州市安远县"),
    CODE_360727("360727", "江西省赣州市龙南县"),
    CODE_360728("360728", "江西省赣州市定南县"),
    CODE_360729("360729", "江西省赣州市全南县"),
    CODE_360730("360730", "江西省赣州市宁都县"),
    CODE_360731("360731", "江西省赣州市于都县"),
    CODE_360732("360732", "江西省赣州市兴国县"),
    CODE_360733("360733", "江西省赣州市会昌县"),
    CODE_360734("360734", "江西省赣州市寻乌县"),
    CODE_360735("360735", "江西省赣州市石城县"),
    CODE_360781("360781", "江西省赣州市瑞金市"),
    CODE_360782("360782", "江西省赣州市南康市"),
    CODE_362200("362200", "江西省宜春地区"),
    CODE_362201("362201", "江西省宜春地区宜春市"),
    CODE_362202("362202", "江西省宜春地区丰城市"),
    CODE_362203("362203", "江西省宜春地区樟树市"),
    CODE_362204("362204", "江西省宜春地区高安市"),
    CODE_362226("362226", "江西省宜春地区奉新县"),
    CODE_362227("362227", "江西省宜春地区万载县"),
    CODE_362228("362228", "江西省宜春地区上高县"),
    CODE_362229("362229", "江西省宜春地区宜丰县"),
    CODE_362232("362232", "江西省宜春地区靖安县"),
    CODE_362233("362233", "江西省宜春地区铜鼓县"),
    CODE_362300("362300", "江西省上饶地区"),
    CODE_362301("362301", "江西省上饶地区上饶市"),
    CODE_362302("362302", "江西省上饶地区德兴市"),
    CODE_362321("362321", "江西省上饶地区上饶县"),
    CODE_362322("362322", "江西省上饶地区广丰县"),
    CODE_362323("362323", "江西省上饶地区玉山县"),
    CODE_362324("362324", "江西省上饶地区铅山县"),
    CODE_362325("362325", "江西省上饶地区横峰县"),
    CODE_362326("362326", "江西省上饶地区弋阳县"),
    CODE_362329("362329", "江西省上饶地区余干县"),
    CODE_362330("362330", "江西省上饶地区波阳县"),
    CODE_362331("362331", "江西省上饶地区万年县"),
    CODE_362334("362334", "江西省上饶地区婺源县"),
    CODE_362400("362400", "江西省吉安地区"),
    CODE_362401("362401", "江西省吉安地区吉安市"),
    CODE_362402("362402", "江西省吉安地区井冈山市"),
    CODE_362421("362421", "江西省吉安地区吉安县"),
    CODE_362422("362422", "江西省吉安地区吉水县"),
    CODE_362423("362423", "江西省吉安地区峡江县"),
    CODE_362424("362424", "江西省吉安地区新干县"),
    CODE_362425("362425", "江西省吉安地区永丰县"),
    CODE_362426("362426", "江西省吉安地区泰和县"),
    CODE_362427("362427", "江西省吉安地区遂川县"),
    CODE_362428("362428", "江西省吉安地区万安县"),
    CODE_362429("362429", "江西省吉安地区安福县"),
    CODE_362430("362430", "江西省吉安地区永新县"),
    CODE_362432("362432", "江西省吉安地区宁冈县"),
    CODE_362500("362500", "江西省抚州地区"),
    CODE_362502("362502", "江西省抚州地区临川市"),
    CODE_362522("362522", "江西省抚州地区南城县"),
    CODE_362523("362523", "江西省抚州地区黎川县"),
    CODE_362524("362524", "江西省抚州地区南丰县"),
    CODE_362525("362525", "江西省抚州地区崇仁县"),
    CODE_362526("362526", "江西省抚州地区乐安县"),
    CODE_362527("362527", "江西省抚州地区宜黄县"),
    CODE_362528("362528", "江西省抚州地区金溪县"),
    CODE_362529("362529", "江西省抚州地区资溪县"),
    CODE_362531("362531", "江西省抚州地区东乡县"),
    CODE_362532("362532", "江西省抚州地区广昌县"),;
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    AreaCodeJXEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    @Override
    public boolean isExist(String code) {
        return Arrays.stream(values()).filter(v -> v.code.equals(code)).findFirst().isPresent();
    }

}
