package com.qiho.center.api.remoteservice.component;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.ResultDto;
import com.qiho.center.api.dto.component.ComponentDto;
import com.qiho.center.api.enums.component.ComponentTypeEnum;

import java.util.List;

/**
 * @author chensong
 * @create 2018-07-25
 */
@AdvancedFeignClient
public interface RemoteComponentService {

    /**
     * 根据id查询组件
     * @param id
     * @return
     */
    ComponentDto findById(Long id);

    /**
     * 新增组件
     * @param componentDto
     * @return
     */
    ResultDto<Long> createComponent(ComponentDto componentDto);

    /**
     * 更新组件
     * @param componentDto
     * @return
     */
    ResultDto<Long> updateComponent(ComponentDto componentDto);

    /**
     * 根据类型获取主键列表
     * @param type
     * @return
     */
    List<ComponentDto> listByType(ComponentTypeEnum type);

    /**
     * 根据id集合批量获取组件
     * @param idList
     * @return
     */
    List<ComponentDto> listBatchByIds(List<Long> idList);

    /**
     * 隐藏组件
     *
     * @param componentId 组件id
     * @param operator 操作人名称
     * @return 是否成功
     */
    Boolean hideComponent(Long componentId, String operator);
}
