package com.qiho.center.api.remoteservice.logistics;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import com.alibaba.fastjson.JSONObject;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.logistics.LogisticsDto;
import com.qiho.center.api.dto.logistics.LogisticsNicknameDto;
import com.qiho.center.api.params.logitics.LogisticsQueryParam;

import java.util.List;

/**
 * 物流服务远程接口
 *
 * @author chensong
 * @create 2017-12-28 16:41
 **/
@AdvancedFeignClient
public interface RemoteLogisticsService {

    /**
     * 获取所有物流公司列表
     *
     * @return 集合
     */
    List<LogisticsDto> findAll();

    /**
     * 分页查询物流公司信息
     *
     * @param param
     *
     * @return
     */
    PagenationDto<LogisticsDto> queryPage(LogisticsQueryParam param);

    /**
     * 获取物流公司的外部名称
     *
     * @param logisticsId 物流公司id
     *
     * @return
     */
    List<LogisticsNicknameDto> findNickname(Long logisticsId);

    /**
     * 添加物流公司外部名称
     *
     * @param dto
     *
     * @return
     */
    Boolean addNickname(LogisticsNicknameDto dto) throws BizException;

    /**
     * 删除物流公司外部名称
     *
     * @param logisticsId
     *
     * @return
     */
    Boolean deleteNickname(Long logisticsId) throws BizException;

    /**
     * 根据code获取物流公司信息
     *
     * @param logisticsCode code
     *
     * @return 信息
     */
    LogisticsDto findByCode(String logisticsCode);

    /**
     * 新增物流公司
     *
     * @param dto
     *
     * @return
     */
    Boolean insertLogistics(LogisticsDto dto);

    /**
     * 删除物流公司
     *
     * @param id
     *
     * @return
     */
    Boolean deleteLogistics(Long id);

}
