package com.qiho.center.api.constant;

import com.google.common.collect.Maps;
import com.qiho.center.api.enums.AfterSaleOrderStageEnum;
import com.qiho.center.api.enums.order.AfterSaleOperateTypeEnum;

import java.util.Map;

/**
 * Created by danke on 2017/10/10.
 */
public class AfterSaleConstant {

    private AfterSaleConstant() {
    }

    /**
     * 售后扩展字段key,时间节点
     */
    public static final String DETAIL_STAGE = "detailStage";

    public static final String CLOSED_REMARK = "退货完成";

    public static final Map<Integer, String> OPERATE_STAGE_MAP = Maps.newHashMap();

    static {
        OPERATE_STAGE_MAP.put(AfterSaleOperateTypeEnum.START.getType(), AfterSaleOrderStageEnum.TO_APPROVE.getCode());
        OPERATE_STAGE_MAP.put(AfterSaleOperateTypeEnum.REFUND_AND_PRODUCT.getType(), AfterSaleOrderStageEnum.SUBMIT_LOGISTICS.getCode());
        OPERATE_STAGE_MAP.put(AfterSaleOperateTypeEnum.REVERT_REFUND.getType(), AfterSaleOrderStageEnum.CANCEL.getCode());
        OPERATE_STAGE_MAP.put(AfterSaleOperateTypeEnum.PAY_AGAIN.getType(), AfterSaleOrderStageEnum.PAY_AGAIN.getCode());
        OPERATE_STAGE_MAP.put(AfterSaleOperateTypeEnum.CONFIRM_REFUND_SUCCESS.getType(), AfterSaleOrderStageEnum.REFUND_SUCCESS.getCode());
        OPERATE_STAGE_MAP.put(AfterSaleOperateTypeEnum.AGREE.getType(), AfterSaleOrderStageEnum.AGREE.getCode());
        OPERATE_STAGE_MAP.put(AfterSaleOperateTypeEnum.CONFIRM_RECEIVE.getType(), AfterSaleOrderStageEnum.ITEM_RECEIVE.getCode());
        OPERATE_STAGE_MAP.put(AfterSaleOperateTypeEnum.HAVE_MONEY.getType(), AfterSaleOrderStageEnum.HAVE_MONEY.getCode());
        OPERATE_STAGE_MAP.put(AfterSaleOperateTypeEnum.REJECT_REFUND.getType(), AfterSaleOrderStageEnum.REJECT_REFUND.getCode());
    }
}
