package com.qiho.center.api.constant;

/**
 * Created by danke on 2017/10/16.
 * 针对config表的configname列举的常量
 */
public class ConfigConstant {

    private ConfigConstant(){}

    public static final String BARRAGECONFIG = "barrageconfig";

    public static final String ALIPAY = "ALIPAY";

    public static final String NOWPAY = "NOWPAY";

    public static final String WECHATPAY = "WECHATPAY";

    public static final String WECHATPAY_PUB = "WECHATPAY_PUB";

    public static final String ATMOSPHERE = "atmosphere";

    public static final String MONITOR_MOBILE = "monitormobile";

    //ERP平台切换配置开关key
    public static final String ERP_MANUFACTURER_TYPE = "ERP_MANUFACTURER_TYPE";

    // 媒体监控的告警阈值Key
    public static final String MEDIA_MONITOR_THRESHOLD = "MEDIA_MONITOR_THRESHOLD";

    public static final String MEDIA_ORDER_NUM_MONITOR_THRESHOLD = "MEDIA_ORDER_NUM_MONITOR_THRESHOLD";

    /** 订单原始信息查看权限的用户邮箱 */
    public static final String ORDER_PRIMITIVE_AUTH_EMAIL = "ORDER_PRIMITIVE_AUTH_EMAIL";

    /** 商品广告位的配置key */
    public static final String DEFAULT_ITEM_ADVERT = "DEFAULT_ITEM_ADVERT";

    /** 继续逛逛的跳转url配置key */
    public static final String KEEP_AROUND_URL = "KEEP_AROUND_URL";

    /** 微信商品的配置key 前缀 */
    private static final String WECHART_ITEM_CONFIG_PRE = "WECHAT_ITEM_";

    /** 快递鸟订阅比率 小数形式保存 */
    public static final String EXPRESSBIRD_SUBSCRIBE_RATE = "EXPRESSBIRD_SUBSCRIBE_RATE";

    /** 百奇定制下单结果页链接 */
    public static final String BAIQI_CUSTOMIZE_LINK = "BAIQI_CUSTOMIZE_LINK";

    /** 需要开启定制下单结果页链接的媒体集合 */
    public static final String BAIQI_CUSTOMIZE_APPS = "BAIQI_CUSTOMIZE_APPS";


    /**
     * 针对微信商品的配置  获取商品config的name
     * @param itemId
     * @return
     */
    public static String getWechatItemConfigName(Long itemId){
        return WECHART_ITEM_CONFIG_PRE + itemId;
    }

}
