package com.qiho.center.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * Created by danke on 2017/10/13.
 * 发起售后原因
 */
public enum AfterSaleOrderReasonEnum {

    SEVEN_DAY("SEVEN_DAY","7天无理由"),
    DESC_WRONG("DESC_WRONG","商品描述不符"),
    QUALITY_PROBLEM("QUALITY_PROBLEM","商品质量问题"),
    ITEM_BROKEN("ITEM_BROKEN","商品破损"),
    ITEM_WRONG("ITEM_WRONG","商品错发漏发"),
    UNWANTED("UNWANTED", "多拍/错拍/不想要"),
    WRONG_ADRESS_PHONE("WRONG_ADRESS_PHONE", "地址/电话信息填错"),
    ORDER_INFO_ERROR("ORDER_INFO_ERROR", "订单信息拍错"),
    EXPRESS_NOT_ARRIVE("EXPRESS_NOT_ARRIVE", "快递一直未送达"),
    SEND_TOO_LATE("SEND_TOO_LATE", "发货太晚"),
    CONSUMER_REJECT("CONSUMER_REJECT","买家拒签"),
    FAKE_BRAND("FAKE_BRAND", "假冒品牌"),
    OTHER("OTHER", "其他");

    private String code;
    private String msg;

    AfterSaleOrderReasonEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    /**
     * @param code
     * @return DatabaseSchema
     */
    public static AfterSaleOrderReasonEnum getByCode(String code) {
        for (AfterSaleOrderReasonEnum enumVal : AfterSaleOrderReasonEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

}
