package com.qiho.center.api.enums.area.code;

import com.qiho.center.api.enums.area.AreaCodeEnumerable;

import java.util.Arrays;

public enum AreaCodeBJEnum implements AreaCodeEnumerable {
    CODE_110000("110000", "北京市"),
    CODE_110100("110100", "北京市市辖区"),
    CODE_110101("110101", "北京市东城区"),
    CODE_110102("110102", "北京市西城区"),
    CODE_110103("110103", "北京市崇文区"),
    CODE_110104("110104", "北京市宣武区"),
    CODE_110105("110105", "北京市朝阳区"),
    CODE_110106("110106", "北京市丰台区"),
    CODE_110107("110107", "北京市石景山区"),
    CODE_110108("110108", "北京市海淀区"),
    CODE_110109("110109", "北京市门头沟区"),
    CODE_110111("110111", "北京市房山区"),
    CODE_110112("110112", "北京市通州区"),
    CODE_110113("110113", "北京市顺义区"),
    CODE_110200("110200", "北京市县"),
    CODE_110221("110221", "北京市昌平县"),
    CODE_110224("110224", "北京市大兴县"),
    CODE_110226("110226", "北京市平谷县"),
    CODE_110227("110227", "北京市怀柔县"),
    CODE_110228("110228", "北京市密云县"),
    CODE_110229("110229", "北京市延庆县");
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    AreaCodeBJEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    @Override
    public boolean isExist(String code) {
         return Arrays.stream(values()).filter(v -> v.code.equals(code)).findFirst().isPresent();
    }
}
