package com.qiho.center.api.enums.order;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang.StringUtils;

/**
 * @author huangruodan
 * @version 创建时间：2020/10/20 4:08 下午
 */
@Getter
@AllArgsConstructor
public enum AfterSaleOrderSubStatusEnum {
    TO_COMFIRM("TO_COMFIRM", "申请中"),
    REFUND_REJECT("REFUND_REJECT", "退款拒绝"),
    TO_BE_RETURN("TO_BE_RETURN", "待退货"),
    TO_BE_RECEIVE("TO_BE_RECEIVE", "待收货"),
    RETURN_PRODUCT_REJECT("RETURN_PRODUCT_REJECT", "退货拒绝"),
    TO_BE_REFUND("TO_BE_REFUND", "退款中"),
    REFUND_FAIL("REFUND_FAIL","退款失败"),
    REFUND_CANCEL("REFUND_CANCEL", "退款取消"),
    REFUND_SUCCESS("REFUND_SUCCESS", "退款成功");


    private String status;

    private String desc;

    public static AfterSaleOrderSubStatusEnum getByCode(String code) {
        for (AfterSaleOrderSubStatusEnum enumVal : AfterSaleOrderSubStatusEnum.values()) {
            if (StringUtils.equals(code, enumVal.getStatus())) {
                return enumVal;
            }
        }
        return null;
    }
}
