package com.qiho.center.api.remoteservice.trading.record;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.trading.record.ShopTradingDailyRecordDto;
import com.qiho.center.api.dto.trading.record.ShopTradingRecordDto;
import com.qiho.center.api.dto.trading.record.ShopTradingRecordDtoOrigin;
import com.qiho.center.api.dto.trading.statistics.ShopTradingStatisticsTotalDto;
import com.qiho.center.api.params.trading.record.ShopTradingRecordPageParam;

import java.util.List;

/**
 * @author Wangpf
 * @description   商家流水
 * @date 2020/9/1 5:40 下午
 */
@AdvancedFeignClient
public interface RemoteShopTradingRecordService {

    /**
     *  分页查询商家订单流水
     * @param shopTradingRecordPageParam
     * @return
     */
    PagenationDto<ShopTradingRecordDto> pageQuery(ShopTradingRecordPageParam shopTradingRecordPageParam);

    /**
     * 计算总金额
     *
     * @return
     */
    ShopTradingStatisticsTotalDto totalQuery(ShopTradingRecordPageParam shopTradingRecordPageParam);

    /**
     * 根据订单Id
     *
     * @param orderId
     * @return
     */
    ShopTradingRecordDtoOrigin findRecordByOrderId(String orderId);

    /**
     * 根据订单Id列表
     *
     * @param orderIdList
     * @return
     */
    List<ShopTradingRecordDtoOrigin> findRecordByOrderIdList(List<String> orderIdList);

    /**
     *  分页查询商家订单流水（以商家ID进行分组统计）
     * @param shopTradingRecordPageParam
     * @return
     */
    PagenationDto<ShopTradingDailyRecordDto> dailyPageQuery(ShopTradingRecordPageParam shopTradingRecordPageParam);

    /**
     *  分页查询商家订单流水（指定商家Id,按照日期进行分组 yyyy-MM-dd）
     * @param shopTradingRecordPageParam
     * @return
     */
    PagenationDto<ShopTradingDailyRecordDto> dailyPageQueryForShop(ShopTradingRecordPageParam shopTradingRecordPageParam);
}
