/**
 * Project Name:qiho-center-api File Name:ItemSkuDto.java Package Name:com.qiho.center.api.dto Date:2017年5月18日下午5:23:18
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.api.dto;

/**
 * ClassName:ItemSkuDto <br/>
 * SKU dto <br/>
 * Date: 2017年5月18日 下午5:23:18 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public class ItemSkuDto extends BaseDto {

    /**
     *
     */
    private static final long serialVersionUID = -5831807878179693646L;

    /**
     * skuId
     */
    private Long id;

    /**
     * 商品ID
     */
    private Long itemId;

    /**
     * 库存ID
     */
    private Long stockId;

    /**
     * 库存数量
     */
    private Long stock;

    /**
     * 更新操作时需要填写库存增减数量
     */
    private Long stockChanges;

    /**
     * 售价，单位：分
     */
    private Integer sellingPrice;

    /**
     * 原价， 单位：分
     */
    private Integer originalPrice;

    /**
     * 成本价， 单位：分
     */
    private Integer costPrice;

    /**
     * 促销价，单位：分
     */
    private Integer promotionPrice;

    /**
     * sku名称
     */
    private String skuName;

    /**
     * 属性字符串
     */
    private String properties;

    /**
     * 商品编码
     */
    private String skuNo;

    /**
     * 是否有效
     */
    private Boolean skuEnable;

    /**
     * 到付价格/用户真实付费价格， 单位：分
     */
    private Integer realPayPrice;

    /**
     * id.
     *
     * @return the id
     */
    public Long getId() {
        return id;
    }

    /**
     * id.
     *
     * @param id the id to set
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * itemId.
     *
     * @return the itemId
     */
    public Long getItemId() {
        return itemId;
    }

    /**
     * itemId.
     *
     * @param itemId the itemId to set
     */
    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    /**
     * stockId.
     *
     * @return the stockId
     */
    public Long getStockId() {
        return stockId;
    }

    /**
     * stockId.
     *
     * @param stockId the stockId to set
     */
    public void setStockId(Long stockId) {
        this.stockId = stockId;
    }

    
    /**
     * stock.
     *
     * @return  the stock
     */
    public Long getStock() {
        return stock;
    }

    
    /**
     * stock.
     *
     * @param   stock    the stock to set
     */
    public void setStock(Long stock) {
        this.stock = stock;
    }

    /**
     * stockChanges.
     *
     * @return the stockChanges
     */
    public Long getStockChanges() {
        return stockChanges;
    }

    /**
     * stockChanges.
     *
     * @param stockChanges the stockChanges to set
     */
    public void setStockChanges(Long stockChanges) {
        this.stockChanges = stockChanges;
    }

    /**
     * sellingPrice.
     *
     * @return the sellingPrice
     */
    public Integer getSellingPrice() {
        return sellingPrice;
    }

    /**
     * sellingPrice.
     *
     * @param sellingPrice the sellingPrice to set
     */
    public void setSellingPrice(Integer sellingPrice) {
        this.sellingPrice = sellingPrice;
    }

    /**
     * originalPrice.
     *
     * @return the originalPrice
     */
    public Integer getOriginalPrice() {
        return originalPrice;
    }

    /**
     * originalPrice.
     *
     * @param originalPrice the originalPrice to set
     */
    public void setOriginalPrice(Integer originalPrice) {
        this.originalPrice = originalPrice;
    }

    /**
     * costPrice.
     *
     * @return the costPrice
     */
    public Integer getCostPrice() {
        return costPrice;
    }

    /**
     * costPrice.
     *
     * @param costPrice the costPrice to set
     */
    public void setCostPrice(Integer costPrice) {
        this.costPrice = costPrice;
    }

    /**
     * skuName.
     *
     * @return the skuName
     */
    public String getSkuName() {
        return skuName;
    }

    /**
     * skuName.
     *
     * @param skuName the skuName to set
     */
    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    /**
     * properties.
     *
     * @return the properties
     */
    public String getProperties() {
        return properties;
    }

    /**
     * properties.
     *
     * @param properties the properties to set
     */
    public void setProperties(String properties) {
        this.properties = properties;
    }

    /**
     * skuNo.
     *
     * @return the skuNo
     */
    public String getSkuNo() {
        return skuNo;
    }

    /**
     * skuNo.
     *
     * @param skuNo the skuNo to set
     */
    public void setSkuNo(String skuNo) {
        this.skuNo = skuNo;
    }

    /**
     * skuEnable.
     *
     * @return the skuEnable
     */
    public Boolean getSkuEnable() {
        return skuEnable;
    }

    /**
     * skuEnable.
     *
     * @param skuEnable the skuEnable to set
     */
    public void setSkuEnable(Boolean skuEnable) {
        this.skuEnable = skuEnable;
    }

    public Integer getRealPayPrice() {
        return realPayPrice;
    }

    public void setRealPayPrice(Integer realPayPrice) {
        this.realPayPrice = realPayPrice;
    }

    public Integer getPromotionPrice() {
        return promotionPrice;
    }

    public void setPromotionPrice(Integer promotionPrice) {
        this.promotionPrice = promotionPrice;
    }
}
