package com.qiho.center.api.enums.flag;

import java.util.Objects;

/**
 * 售后状态flag
 */
public enum FlagAfterSaleStatusEnum {
    NONE(0), // 无售后、售后取消、售后结束

    HANDLING(1); // 售后中

    private int status;

    FlagAfterSaleStatusEnum(int status){
        this.status = status;
    }

    public int getStatus() {
        return status;
    }

    public static FlagAfterSaleStatusEnum getByStatus(Integer status){
        if (Objects.isNull(status)) {
            return null;
        }
        for (FlagAfterSaleStatusEnum enumVal : FlagAfterSaleStatusEnum.values()) {
            if (enumVal.status == status) {
                return enumVal;
            }
        }
        return null;
    }
}
