package com.qiho.center.api.dto.order;

import java.util.Date;

import com.qiho.center.api.dto.BaseDto;

/**
 * 订单记录操作Dto对象
 *
 * @author chensong
 * @create 2017-12-28 16:53
 **/
public class DeliveryRecordDto extends BaseDto {

    /**
     * id
     */
    private Long id;

    /**
     * 商家id
     */
    private Long merchantId;

    /**
     * 物流公司编码
     */
    private String logisticsCode;

    /**
     * 批量审核的文件地址
     */
    private String fileUrl;

    /**
     * 原文件名称
     */
    private String originFileName;

    /**
     * 处理结果
     */
    private String remark;

    /**
     * 操作类型：1=批量发货、2=取消发货
     */
    private Integer recordType;

    /**
     * 总条数
     */
    private Integer totalCount;

    /**
     * 失败条数
     */
    private Integer failedCount;

    /**
     * 成功条数
     */
    private Integer succeedCount;

    /**
     * 更新条数
     */
    private Integer updatedCount;

    /**
     * 状态：0=未开始、1=处理中、2=完成
     */
    private Integer state;

    /**
     * 删除标识，0-否 ，1-是
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(Long merchantId) {
        this.merchantId = merchantId;
    }

    public String getLogisticsCode() {
        return logisticsCode;
    }

    public void setLogisticsCode(String logisticsCode) {
        this.logisticsCode = logisticsCode;
    }

    public String getFileUrl() {
        return fileUrl;
    }

    public void setFileUrl(String fileUrl) {
        this.fileUrl = fileUrl;
    }

    public String getOriginFileName() {
        return originFileName;
    }

    public void setOriginFileName(String originFileName) {
        this.originFileName = originFileName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getRecordType() {
        return recordType;
    }

    public void setRecordType(Integer recordType) {
        this.recordType = recordType;
    }

    public Integer getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Integer getFailedCount() {
        return failedCount;
    }

    public void setFailedCount(Integer failedCount) {
        this.failedCount = failedCount;
    }

    public Integer getSucceedCount() {
        return succeedCount;
    }

    public void setSucceedCount(Integer succeedCount) {
        this.succeedCount = succeedCount;
    }

    public Integer getUpdatedCount() {
        return updatedCount;
    }

    public void setUpdatedCount(Integer updatedCount) {
        this.updatedCount = updatedCount;
    }

    @Override
    public String toString() {
        return "DeliveryRecordDto{" + "id=" + id + ", merchantId=" + merchantId + ", logisticsCode='" + logisticsCode
            + '\'' + ", fileUrl='" + fileUrl + '\'' + ", originFileName='" + originFileName + '\'' + ", remark='"
            + remark + '\'' + ", recordType=" + recordType + ", totalCount=" + totalCount + ", failedCount="
            + failedCount + ", succeedCount=" + succeedCount + ", updatedCount=" + updatedCount + ", state=" + state
            + ", deleted=" + deleted + ", gmtCreate=" + gmtCreate + ", gmtModified=" + gmtModified + '}';
    }
}
