package com.qiho.center.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * Created by danke on 2017/9/25.
 */
public enum LogisticsOrderProcessEnum {

    PROCESS_YES("YES","已经处理","is not null"),
    PROCESS_NO("NO","未处理","is null");

    private String code;
    private String msg;
    private String val;

    LogisticsOrderProcessEnum(String code, String msg, String val) {
        this.code = code;
        this.msg = msg;
        this.val = val;
    }

    /**
     * 通过code值去获取对应的枚举
     * @param code
     */
    public static LogisticsOrderProcessEnum fromVal(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        for (LogisticsOrderProcessEnum logisticsOrderProcessEnum : LogisticsOrderProcessEnum.values()) {
            if (logisticsOrderProcessEnum.getCode().equals(code)) {
                return logisticsOrderProcessEnum;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    public String getVal() {
        return val;
    }

}
