package com.qiho.center.api.enums.log;

import com.qiho.center.api.enums.CancelOperateTypeEnum;
import com.qiho.center.api.enums.order.OrderOperatorTypeEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @author huangruodan
 * @version 创建时间：2020/12/14 3:24 下午
 */
@Getter
@AllArgsConstructor
public enum  OrderLogOperatorTypeEnum {

    DEFAULT(0, "默认"),
    MERCHANT(1, "商家"),
    TUIA(2, "推啊"),
    ROBOT(3, "机器人");

    private Integer type;

    private String desc;

    //value为OrderLogOperatorTypeEnum key为OrderOperatorTypeEnum
    private static Map<Integer, Integer> orderLogMap = new HashMap<>();
    //value为OrderLogOperatorTypeEnum key为CancelOperateTypeEnum
    private static Map<Integer, Integer> cancelOperateTypeEnumMap = new HashMap<>();

    static {
        orderLogMap.put(OrderOperatorTypeEnum.MERCHANT.getType(), MERCHANT.getType());
        orderLogMap.put(OrderOperatorTypeEnum.CUSTOMER_SERVICE.getType(), TUIA.getType());
        orderLogMap.put(OrderOperatorTypeEnum.ROBOT.getType(), ROBOT.getType());

        cancelOperateTypeEnumMap.put(CancelOperateTypeEnum.DEFAULT.getCode(), DEFAULT.getType());
        cancelOperateTypeEnumMap.put(CancelOperateTypeEnum.TUI_A.getCode(), TUIA.getType());
        cancelOperateTypeEnumMap.put(CancelOperateTypeEnum.BUSINESS.getCode(), MERCHANT.getType());
        cancelOperateTypeEnumMap.put(CancelOperateTypeEnum.ROBOT.getCode(), ROBOT.getType());
    }

    /**
     * 根据OrderOperatorTypeEnum 获取type
     * @param type
     * @return
     */
    public static Integer getTypeByOrderOperatorType (Integer type) {
        if (type == null) {
            return DEFAULT.getType();
        }
        Integer logType = orderLogMap.get(type);
        return logType == null ? DEFAULT.getType() : logType;
    }

    /**
     * 根据CancelOperateTypeEnum 获取type
     * @param type
     * @return
     */
    public static Integer getTypeByCancelOperateType (Integer type) {
        if (type == null) {
            return DEFAULT.getType();
        }
        Integer logType = cancelOperateTypeEnumMap.get(type);
        return logType == null ? DEFAULT.getType() : logType;
    }


}
