package com.qiho.center.api.enums.user;

import java.util.Arrays;

/**
 * @author peanut.huang
 * @date 2018/1/26.
 */
public enum UserTypeEnum {

    /**
     *
     */
    WECHAT(1, "微信用户")

    ;

    /**
     * value
     */
    private int value;

    /**
     * value's description
     */
    private String desc;

    UserTypeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    /**
     * 根据值获取
     *
     * @param value
     * @return
     */
    public static UserTypeEnum findByValue(int value){
        return Arrays.stream(UserTypeEnum.values()).filter(e -> e.getValue() == value).findFirst().orElse(null);
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }
}
