package com.qiho.center.api.params.template;

import lombok.*;

import java.io.Serializable;

/**
 * @author Wangpf
 * @description  保存短信模板参数
 * @date 2019/9/12 5:14 PM
 */

@Data
@Builder
@ToString
@AllArgsConstructor
@NoArgsConstructor
public class TemplateParams implements Serializable {

    private static final long serialVersionUID = -9036722859835333769L;

    /**
     * 短信模板Id
     */
    private Long id;

    /**
     * 模板代码
     */
    private String templateCode;

    /**
     * 模板名称
     */
    private String templateName;

    /**
     * 模板内容
     */
    private String templateContext;

    /**
     * 模板id
     */
    private String noteTemplateId;

    /**
     * 短信通道类型
     */
    private String smsType;

    /**
     * 绑定的商家id
     */
    private String relatedMerchantIds;

    /**
     * 绑定的媒体id
     */
    private String relatedAppIds;

    /**
     * 中台短信模版Id
     */
    private Long modelId;

    /**
     * 短信签名Id
     */
    private Long signId;
}
