package com.qiho.center.api.params.trading.statistics;

import lombok.Data;

/**
 * @author Wangpf
 * @description 更新商家总账单参数
 * @date 2020/9/3 2:54 下午
 */
@Data
public class TradingStatisticsUpdateParam {

    /**
     * 店铺ID
     */
    private Long shopId;

    /**
     * 增加的订单数量
     */
    private Long orderCountToAdd;

    /**
     * 增加的账户总金额
     */
    private Long paymentDaysTotalAmountToAdd;

    /**
     * 增加的手续费
     */
    private Integer poundageAmtToAdd;

    /**
     * 增加的退款总金额 单位：分
     */
    private Integer refundTotalAmtToAdd;

    /**
     * 增加已经结算总金额，单位：分
     */
    private Integer settledAmountToAdd;

    /**
     * 增加的待结算总金额，单位：分
     */
    private Integer waitSettleAmountToAdd;

    /**
     * 减去的待结算总金额，单位：分
     */
    private Integer waitSettleAmountToSubtract;

    /**
     * 增加的提现总金额，单位：分
     */
    private Integer alreadyWithdrawalAmountToAdd;

    /**
     * 增加的待提现总金额，单位：分
     */
    private Integer waitWithdrawalAmountToAdd;

    /**
     * 减去的待提现总金额，单位：分
     */
    private Integer waitWithdrawalAmountToSubtract;
}
