package com.qiho.center.api.remoteservice.account;

import com.qiho.center.api.dto.account.BaiqiAccountDto;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * Created by sunchangji on 2017/12/7.
 */
@AdvancedFeignClient
public interface RemoteBaiqiAccountService {

    BaiqiAccountDto findByAccount(String account);

    BaiqiAccountDto findByMobile(String mobile);

    /**
     * 根据账号id获取账号名称
     *
     * @param id 账号id
     * @return 账号名称
     */
    String findAccountById(Long id);

    /**
     * 更新密码
     *
     * @param id     账号id
     * @param newPwd 密码
     * @return
     */
    Boolean updatePwd(Long id, String newPwd);

    BaiqiAccountDto findById(Long id);

    /**
     * 根据商家id查询商家主账号
     *
     * @param merchantId 商家id
     * @return
     */
    BaiqiAccountDto findMainAccountByMerchantId(Long merchantId);

    /**
     * 根据账户类型和关联id查询账户
     *
     * @return
     */
    BaiqiAccountDto findByTypeAndRelationId(Integer accountType, Long relationId);

    /**
     * 根据ID 批量查询账号信息
     *
     * @param ids
     * @return
     */
    List<BaiqiAccountDto> findByIds(List<Long> ids);
}
