package com.qiho.center.api.remoteservice.finance;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.BaseResultDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.account.BaiqiFinanceRechargeDetailDto;
import com.qiho.center.api.dto.account.BaiqiFinanceRechargeDto;
import com.qiho.center.api.params.finance.BaiqiFinanceRechargeQryParam;

/**
 * 商户充值中心
 * Author: zhanghuifeng
 * Date:   9:48 2017/12/21
 */
@AdvancedFeignClient
public interface RemoteBaiqiFinanceRechargeBackendService {

	/**
	 * 分页查询所有商户充值列表
	 * @param params  数据
	 * @return 数据
	 */
	PagenationDto<BaiqiFinanceRechargeDetailDto> find4Page(BaiqiFinanceRechargeQryParam params);

	/**
	 * 提交充值申请
	 * @param dto 参数
	 * @return boolean
	 */
	Boolean rechargeSubmit(BaiqiFinanceRechargeDto dto);

	/**充值审批
	 *
	 * @param rechargeNo  充值单号
	 * @param state 需要变更状态
	 * @param operator 操作人
	 * @return 结果
	 */
	BaseResultDto audit(Long rechargeNo, Integer state, String operator);

	/**
	 *  获取充值信息
	 * @param rechargeNo 单号
	 * @return 信息
	 */
	BaiqiFinanceRechargeDetailDto findByNo(Long rechargeNo);
}
