package com.qiho.center.api.remoteservice.order;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.AfterSaleOrderDto;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.order.AfterSaleOrderDetailDto;
import com.qiho.center.api.dto.order.param.AfterSaleOrderParam;
import com.qiho.center.api.params.AfterSaleQueryParams;

import java.util.List;

/**
 * Created by danke on 2017/10/10.
 * 售后子订单接口
 */
@AdvancedFeignClient
public interface RemoteAfterSaleOrderService {

    /**
     * 新增售后订单
     * @param afterSaleOrderDto       售后订单内容
     * @return 售后订单id
     */
    String save(AfterSaleOrderDto afterSaleOrderDto);

    /**
     * 通过条件分页查询售后子订单
     * @param params
     * @return
     */
    PagenationDto<AfterSaleOrderDto> queryAfterSaleByQuery(AfterSaleQueryParams params);

    /**
     * 通过订单id查询最新的一笔售后订单，
     * @param orderId
     * @return
     */
    List<AfterSaleOrderDto> queryAfterSaleByOrderId(String orderId);

    /**
     * 更新售后订单
     * @param afterSaleOrderDto
     * @return
     */
    Boolean updateAfterSaleByDto(AfterSaleOrderDto afterSaleOrderDto);

    /**
     * 更新扩展字段
     * @return
     */
    Boolean updateMetaValueByAfterSaleId(AfterSaleOrderDto afterSaleOrderDto);

    /**
     * 是否开启售后入口
     * @param orderId
     * @return true-打开，false-不打开
     */
    Boolean openAfterSale(String orderId);

    /**
     * 是否可以发起售后
     * @param orderId
     * @return
     */
    Boolean sponsorAfterSale(String orderId);

    /**
     * 根据orderId查询所有的售后子订单
     * @param orderId
     * @return
     */
    List<AfterSaleOrderDto> findAll(String orderId);

    /**
     * 根据售后子订单id查询售后子订单
     */
    AfterSaleOrderDto queryAfterSaleById(String afterSaleId);

    /**
     * 根据售后子订单id批量查询
     */
    List<AfterSaleOrderDto> queryAfterSaleByIds(List<String> afterSaleIds);


    /**
     * 更新物流信息
     * @param afterSaleOrderDto
     * @return
     */
    Boolean updateLogisticsInfo(AfterSaleOrderDto afterSaleOrderDto);

    /**
     * 根据订单id列表 查询订单的最后的售后子订单状态信息
     * @param orderIds
     * @return
     */
    List<AfterSaleOrderDto> getLastAfterSaleOrderByOrderId(List<String> orderIds);

    /**
     * 获取售后订单详情
     * @param afterSaleId 售后订单id
     * @return 售后订单详情
     */
    AfterSaleOrderDetailDto getAfterSaleOrderDetailById(String orderId, String afterSaleId) throws BizException;

    /**
     * 通过条件分页查询总数
     */
    Integer countAfterSaleByQuery(AfterSaleQueryParams params) throws BizException;

    /**
     * 新增和更新售后订单
     * @param param 售后订单参数
     * @return 售后订单id
     */
    String saveAndUpdateAfterSaleOrder(AfterSaleOrderParam param) throws BizException;

    void fixAfterSaleOrder();

}
