package com.qiho.center.api.remoteservice.template;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.tuia.advert.model.DubboResult;
import com.qiho.center.api.dto.PagenationDto;
import com.qiho.center.api.dto.template.AppWhiteDto;
import com.qiho.center.api.params.template.AppWhitePagingParam;
import com.qiho.center.api.params.template.AppWhiteParam;

/**
 * @author Wangpf
 * @description 媒体白名单
 * @date 2020/2/11 2:48 PM
 */
@AdvancedFeignClient
public interface RemoteAppWhiteService {

    /**
     * 新增短信模板媒体白名单
     *
     * @param appWhiteParam
     * @return
     */
    DubboResult save(AppWhiteParam appWhiteParam);

    /**
     * 分页查询媒体白名单
     *
     * @param appWhitePagingParam 分页查询参数
     * @return
     */
    PagenationDto<AppWhiteDto> pageQuery(AppWhitePagingParam appWhitePagingParam);

    /**
     * 删除当前媒体白名单
     *
     * @param id
     * @return
     */
    boolean delete(Long id);
}
