/**
 * Project Name:qiho-center-api File Name:ErpOrderDto.java Package Name:com.qiho.center.api.dto Date:2017年6月6日上午11:34:05
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.api.dto;

import java.util.Date;

import com.qiho.center.api.enums.DeliveryEnum;
import com.qiho.center.api.enums.ErpStatusEnum;
import com.qiho.center.api.enums.ErpTypeEnum;

/**
 * ClassName:ErpOrderDto <br/>
 * Date: 2017年6月6日 上午11:34:05 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public class ErpOrderDto extends BaseDto {

    /**
     */
    private static final long serialVersionUID = 4436916650357436801L;

    /** 订单ID */
    private String            orderId;

    /** ERP订单ID */
    private String            erpId;

    /** 发货方式，{@link DeliveryEnum} */
    private String            delivery;

    /** ERP类型，{@link ErpTypeEnum} */
    private String            erpType;

    /** 创建时间 */
    private Date              gmtCreate;

    /** 更新时间 */
    private Date              gmtModified;

    /** ERP订单状态，{@link ErpStatusEnum} */
    private String            erpStatus;

    /** 失败原因 */
    private String            failedMessage;

    /** 售后订单ID */
    private String            postsaleId;

    /** 商品ID */
    private Long              itemId;

    /** 商品名称 */
    private String            itemName;

    /** 货号 */
    private String            itemNo;

    /** 商品编码 */
    private String            skuNo;

    /** 买家姓名 */
    private String            consumerName;

    /** 买家电话 */
    private String            mobile;

    /** 省/直辖市 */
    private String            province;

    /** 市 */
    private String            city;

    /** 区县 */
    private String            district;

    /** 详细地址 */
    private String            address;

    /**
     * orderId.
     *
     * @return the orderId
     */
    public String getOrderId() {
        return orderId;
    }

    /**
     * orderId.
     *
     * @param orderId the orderId to set
     */
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    /**
     * erpId.
     *
     * @return the erpId
     */
    public String getErpId() {
        return erpId;
    }

    /**
     * erpId.
     *
     * @param erpId the erpId to set
     */
    public void setErpId(String erpId) {
        this.erpId = erpId;
    }

    /**
     * delivery.
     *
     * @return the delivery
     */
    public String getDelivery() {
        return delivery;
    }

    /**
     * delivery.
     *
     * @param delivery the delivery to set
     */
    public void setDelivery(String delivery) {
        this.delivery = delivery;
    }

    /**
     * erpType.
     *
     * @return the erpType
     */
    public String getErpType() {
        return erpType;
    }

    /**
     * erpType.
     *
     * @param erpType the erpType to set
     */
    public void setErpType(String erpType) {
        this.erpType = erpType;
    }

    /**
     * gmtCreate.
     *
     * @return the gmtCreate
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * gmtCreate.
     *
     * @param gmtCreate the gmtCreate to set
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * gmtModified.
     *
     * @return the gmtModified
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * gmtModified.
     *
     * @param gmtModified the gmtModified to set
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    /**
     * erpStatus.
     *
     * @return the erpStatus
     */
    public String getErpStatus() {
        return erpStatus;
    }

    /**
     * erpStatus.
     *
     * @param erpStatus the erpStatus to set
     */
    public void setErpStatus(String erpStatus) {
        this.erpStatus = erpStatus;
    }

    /**
     * failedMessage.
     *
     * @return the failedMessage
     */
    public String getFailedMessage() {
        return failedMessage;
    }

    /**
     * failedMessage.
     *
     * @param failedMessage the failedMessage to set
     */
    public void setFailedMessage(String failedMessage) {
        this.failedMessage = failedMessage;
    }

    /**
     * postsaleId.
     *
     * @return the postsaleId
     */
    public String getPostsaleId() {
        return postsaleId;
    }

    /**
     * postsaleId.
     *
     * @param postsaleId the postsaleId to set
     */
    public void setPostsaleId(String postsaleId) {
        this.postsaleId = postsaleId;
    }

    /**
     * itemId.
     *
     * @return the itemId
     */
    public Long getItemId() {
        return itemId;
    }

    /**
     * itemId.
     *
     * @param itemId the itemId to set
     */
    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    /**
     * itemName.
     *
     * @return the itemName
     */
    public String getItemName() {
        return itemName;
    }

    /**
     * itemName.
     *
     * @param itemName the itemName to set
     */
    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    /**
     * itemNo.
     *
     * @return the itemNo
     */
    public String getItemNo() {
        return itemNo;
    }

    /**
     * itemNo.
     *
     * @param itemNo the itemNo to set
     */
    public void setItemNo(String itemNo) {
        this.itemNo = itemNo;
    }

    /**
     * skuNo.
     *
     * @return the skuNo
     */
    public String getSkuNo() {
        return skuNo;
    }

    /**
     * skuNo.
     *
     * @param skuNo the skuNo to set
     */
    public void setSkuNo(String skuNo) {
        this.skuNo = skuNo;
    }

    /**
     * consumerName.
     *
     * @return the consumerName
     */
    public String getConsumerName() {
        return consumerName;
    }

    /**
     * consumerName.
     *
     * @param consumerName the consumerName to set
     */
    public void setConsumerName(String consumerName) {
        this.consumerName = consumerName;
    }

    /**
     * mobile.
     *
     * @return the mobile
     */
    public String getMobile() {
        return mobile;
    }

    /**
     * mobile.
     *
     * @param mobile the mobile to set
     */
    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    /**
     * province.
     *
     * @return the province
     */
    public String getProvince() {
        return province;
    }

    /**
     * province.
     *
     * @param province the province to set
     */
    public void setProvince(String province) {
        this.province = province;
    }

    /**
     * city.
     *
     * @return the city
     */
    public String getCity() {
        return city;
    }

    /**
     * city.
     *
     * @param city the city to set
     */
    public void setCity(String city) {
        this.city = city;
    }

    /**
     * district.
     *
     * @return the district
     */
    public String getDistrict() {
        return district;
    }

    /**
     * district.
     *
     * @param district the district to set
     */
    public void setDistrict(String district) {
        this.district = district;
    }

    /**
     * address.
     *
     * @return the address
     */
    public String getAddress() {
        return address;
    }

    /**
     * address.
     *
     * @param address the address to set
     */
    public void setAddress(String address) {
        this.address = address;
    }

}
