package com.qiho.center.api.dto.order;

import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.NotBlank;

import java.io.Serializable;

/**
 * 单笔订单
 * 确认业务
 * 传输数据
 * Created by weny.cai on 2018/3/15.
 */
public class OrderConfirmDto implements Serializable {

    @NotBlank
    @ApiModelProperty("订单编号")
    private String orderId;

    @NotBlank
    @ApiModelProperty("快递公司编号")
    private String express;

    @NotBlank
    @ApiModelProperty("快递单号")
    private String expressCode;

    @ApiModelProperty("操作人")
    private String operator;

    /**
     * 操作类型 {@link com.qiho.center.api.enums.log.OrderLogOperatorTypeEnum}
     */
    private Integer operatorType;

    public Integer getOperatorType() {
        return operatorType;
    }

    public void setOperatorType(Integer operatorType) {
        this.operatorType = operatorType;
    }

    public String getOperator() {
        return operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getExpress() {
        return express;
    }

    public void setExpress(String express) {
        this.express = express;
    }

    public String getExpressCode() {
        return expressCode;
    }

    public void setExpressCode(String expressCode) {
        this.expressCode = expressCode;
    }

}
