package com.qiho.center.api.dto.security.param;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author huangruodan
 * @version 创建时间：2020/8/20 2:57 下午
 */
@Data
public class SecurityFundApplyQueryParam implements Serializable {

    private static final long serialVersionUID = -6600033687273156625L;

    private Integer pageNum;

    private Integer pageSize;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 完成开始时间
     */
    private Date finishStartTime;

    /**
     * 完成结束时间
     */
    private Date finishEndTime;

    /**
     * 商户id
     */
    private Long merchantId;

    /**
     * 商户名称
     */
    private String merchantName;

    /**
     * 操作类型 {@link com.qiho.center.api.enums.security.SecurityFundOperateTypeEnum}
     */
    private Integer operateType;

    /**
     * 申请状态 {@link com.qiho.center.api.enums.security.SecurityFundApplyStatusEnum}
     */
    private Integer applyStatus;

    /**
     * 查询类型 {@link com.qiho.center.api.enums.security.SecurityFundQueryTypeEnum}
     */
    private Integer queryType;

}
