package com.qiho.center.api.enums.area.code;

import com.qiho.center.api.enums.area.AreaCodeEnumerable;

import java.util.Arrays;

public enum AreaCodeQHEnum implements AreaCodeEnumerable {
    CODE_630000("630000", "青海省"),
    CODE_630100("630100", "青海省西宁市"),
    CODE_630101("630101", "青海省西宁市市辖区"),
    CODE_630102("630102", "青海省西宁市城东区"),
    CODE_630103("630103", "青海省西宁市城中区"),
    CODE_630104("630104", "青海省西宁市城西区"),
    CODE_630105("630105", "青海省西宁市城北区"),
    CODE_630121("630121", "青海省西宁市大通回族土族自治县"),
    CODE_632100("632100", "青海省海东地区"),
    CODE_632121("632121", "青海省海东地区平安县"),
    CODE_632122("632122", "青海省海东地区民和回族土族自治县"),
    CODE_632123("632123", "青海省海东地区乐都县"),
    CODE_632124("632124", "青海省海东地区湟中县"),
    CODE_632125("632125", "青海省海东地区湟源县"),
    CODE_632126("632126", "青海省海东地区互助土族自治县"),
    CODE_632127("632127", "青海省海东地区化隆回族自治县"),
    CODE_632128("632128", "青海省海东地区循化撒拉族自治县"),
    CODE_632200("632200", "青海省海北藏族自治州"),
    CODE_632221("632221", "青海省海北藏族自治州门源回族自治县"),
    CODE_632222("632222", "青海省海北藏族自治州祁连县"),
    CODE_632223("632223", "青海省海北藏族自治州海晏县"),
    CODE_632224("632224", "青海省海北藏族自治州刚察县"),
    CODE_632300("632300", "青海省黄南藏族自治州"),
    CODE_632321("632321", "青海省黄南藏族自治州同仁县"),
    CODE_632322("632322", "青海省黄南藏族自治州尖扎县"),
    CODE_632323("632323", "青海省黄南藏族自治州泽库县"),
    CODE_632324("632324", "青海省黄南藏族自治州河南蒙古族自治县"),
    CODE_632500("632500", "青海省海南藏族自治州"),
    CODE_632521("632521", "青海省海南藏族自治州共和县"),
    CODE_632522("632522", "青海省海南藏族自治州同德县"),
    CODE_632523("632523", "青海省海南藏族自治州贵德县"),
    CODE_632524("632524", "青海省海南藏族自治州兴海县"),
    CODE_632525("632525", "青海省海南藏族自治州贵南县"),
    CODE_632600("632600", "青海省果洛藏族自治州"),
    CODE_632621("632621", "青海省果洛藏族自治州玛沁县"),
    CODE_632622("632622", "青海省果洛藏族自治州班玛县"),
    CODE_632623("632623", "青海省果洛藏族自治州甘德县"),
    CODE_632624("632624", "青海省果洛藏族自治州达日县"),
    CODE_632625("632625", "青海省果洛藏族自治州久治县"),
    CODE_632626("632626", "青海省果洛藏族自治州玛多县"),
    CODE_632700("632700", "青海省玉树藏族自治州"),
    CODE_632721("632721", "青海省玉树藏族自治州玉树县"),
    CODE_632722("632722", "青海省玉树藏族自治州杂多县"),
    CODE_632723("632723", "青海省玉树藏族自治州称多县"),
    CODE_632724("632724", "青海省玉树藏族自治州治多县"),
    CODE_632725("632725", "青海省玉树藏族自治州囊谦县"),
    CODE_632726("632726", "青海省玉树藏族自治州曲麻莱县"),
    CODE_632800("632800", "青海省海西蒙古族藏族自治州"),
    CODE_632801("632801", "青海省海西蒙古族藏族自治州格尔木市"),
    CODE_632802("632802", "青海省海西蒙古族藏族自治州德令哈市"),
    CODE_632821("632821", "青海省海西蒙古族藏族自治州乌兰县"),
    CODE_632822("632822", "青海省海西蒙古族藏族自治州都兰县"),
    CODE_632823("632823", "青海省海西蒙古族藏族自治州天峻县"),
    ;
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    AreaCodeQHEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    @Override
    public boolean isExist(String code) {
        return Arrays.stream(values()).filter(v -> v.code.equals(code)).findFirst().isPresent();
    }
}
