/**
 * Project Name:qiho-center-api File Name:RemoteCategoryService.java Package Name:com.qiho.center.api.remoteservice
 * Date:2017年5月16日下午9:24:02 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package com.qiho.center.api.remoteservice;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.CategoryDto;

import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteCategoryService <br/>
 * 类目管理dubbo服务 <br/>
 * Date: 2017年5月16日 下午9:24:02 <br/>
 * 
 * @author zhanglihui
 * @version
 * @see
 */
@AdvancedFeignClient
public interface RemoteCategoryService {

    /**
     * sortByRange:在类目移动范围内排序 <br/>
     * 排序区间为闭区间[startPayload, endPayload]
     *
     * @param pid   父类目ID
     * @param startPayload 排序起始payload值
     * @param endPayload   排序结束payload值
     * @return DubboResult
     * @author zhanglihui
     */
    DubboResult<Void> sortByRange(Long pid, Integer startPayload, Integer endPayload);
    
    /**
     * 根据父类目ID查询子类目
     *
     * @author zhanglihui
     * @param pid
     * @return List<CategoryDto>
     */
    DubboResult<List<CategoryDto>> getCategoryByPid(Long pid);
    
    /**
     * 根据类目ID删除类目，若删除的是父类目，子类目也会被删除
     *
     * @author zhanglihui
     * @param categoryId
     * @return DubboResult
     */
    DubboResult<Void> deleteCategoryById(Long categoryId);
    
    /**
     * 更新类目名称
     *
     * @author zhanglihui
     * @param categoryId
     * @param categoryName
     * @return DubboResult
     */
    DubboResult<Void> updateCategoryById(Long categoryId, String categoryName);
    
    /**
     * 批量新增类目
     *
     * @author zhanglihui
     * @param pid
     * @param categoryList
     * @return DubboResult
     */
    DubboResult<List<CategoryDto>> saveCategory(Long pid, List<String> categoryList);
    
}
