/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.center.api.enums.strategy;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.qiho.center.api.dto.strategy.StrategyGroupDto;
import com.qiho.center.api.dto.strategy.StrategyItemDto;
import com.qiho.center.api.enums.ShotOrder.StrategyType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public enum StrategyGroupEnum {
    MESSAGE("message", "\u7559\u8a00", "message", "\u7528\u6237\u7559\u8a00"),
    CONSUMER_NAME("name", "\u59d3\u540d", "consumerName", "\u6536\u4ef6\u4eba\u59d3\u540d"),
    ADDRESS_INFO("address", "\u5730\u5740", "info-address", "\u8be6\u7ec6\u5730\u5740"),
    ADDRESS_LEN("address", "\u5730\u5740", "address", "\u8be6\u7ec6\u5730\u5740\u957f\u5ea6"),
    MOBILE("mobile", "\u624b\u673a\u53f7", "mobile", "\u4e0b\u5355\u624b\u673a\u53f7\u72b6\u6001"),
    MOBILE_COUNT("mobile", "\u624b\u673a\u53f7", "count-mobile", "24\u5c0f\u65f6\u4e0b\u5355\u91cf(\u624b\u673a\u53f7\u7edf\u8ba1)"),
    mobile_ct_item("mobile", "\u624b\u673a\u53f7", "ct-phone-item", "24\u5c0f\u65f6\u4e0b\u5355\u91cf(\u540c\u4e00\u624b\u673a\u53f7\u540c\u4e00\u5546\u54c1)"),
    MOBILE_CT_MERCHANT("mobile", "\u624b\u673a\u53f7", "ct-phone-merchant", "24\u5c0f\u65f6\u4e0b\u5355\u91cf(\u540c\u4e00\u624b\u673a\u53f7\u540c\u4e00\u5546\u5bb6)"),
    MOBILE_DUPLICATE_HIT("mobile", "\u624b\u673a\u53f7", "mobile-duplicate-hit", "\u624b\u673a\u53f7\u591a\u6b21\u547d\u4e2d\u73b0\u6709\u89c4\u5219"),
    ADDRESS_INVALID("address_invalid", "\u5730\u5740&\u5730\u533a", "invalid-address", "\u5730\u5740\u6709\u6548\u6027"),
    ADDRESS_MOBILE("address_mobile", "\u5730\u5740&\u624b\u673a\u53f7", "ip-mobile-address-check", "IP\u5f52\u5c5e\u5730\u624b\u673a\u53f7\u5f52\u5c5e\u5730\u6536\u8d27\u5730\u5740\u6821\u9a8c"),
    OTHER_tuiaId("other", "\u5176\u4ed6", "tuiaId", "\u63a8\u554aid"),
    OTHER_remainTime("other", "\u5176\u4ed6", "remainTime", "\u9875\u9762\u505c\u7559\u65f6\u957f(\u79d2)"),
    OTHER_itemNo("other", "\u5176\u4ed6", "itemNo", "\u8d27\u53f7"),
    OTHER_itemId("other", "\u5176\u4ed6", "itemId", "\u5546\u54c1id"),
    OTHER_quantity("other", "\u5176\u4ed6", "quantity", "\u8ba2\u5355\u4ef6\u6570"),
    OTHER_countTuiaId("other", "\u5176\u4ed6", "count-tuiaId", "24\u5c0f\u65f6\u4e0b\u5355\u91cf(\u63a8\u554aid\u7edf\u8ba1)"),
    OTHER_countIp("other", "\u5176\u4ed6", "count-ip", "24\u5c0f\u65f6\u4e0b\u5355\u91cf\uff08ip\u7edf\u8ba1\uff09"),
    OTHER_countTuiacid("other", "\u5176\u4ed6", "count-tuiacid", "24\u5c0f\u65f6\u4e0b\u5355\u91cf(\u63a8\u554a\u7528\u6237id\u7edf\u8ba1)"),
    DELIVERY_REGION("region", "\u5730\u533a", "delivery-region", "\u7528\u6237\u6536\u8d27\u5730\u5740\u6821\u9a8c"),
    ID_CARD_AGE("id_card", "\u8eab\u4efd\u8bc1", "age-idCard", "\u8eab\u4efd\u8bc1\u5e74\u9f84"),
    ID_CARD_FORMAT("id_card", "\u8eab\u4efd\u8bc1", "format-idCard", "\u8eab\u4efd\u8bc1\u683c\u5f0f"),
    ID_CARD_AREA("id_card", "\u8eab\u4efd\u8bc1", "area-idCard", "\u8eab\u4efd\u8bc1\u533a\u53f7"),
    ID_CARD_COUNT("id_card", "\u8eab\u4efd\u8bc1", "count-idCard", "24\u5c0f\u65f6\u4e0b\u5355\u91cf(\u8eab\u4efd\u8bc1\u53f7\u7edf\u8ba1)"),
    ID_CARD_ITEM("id_card", "\u8eab\u4efd\u8bc1", "ct-idCard-item", "24\u5c0f\u65f6\u4e0b\u5355\u91cf(\u540c\u4e00\u8eab\u4efd\u8bc1\uff0c\u540c\u4e00\u5546\u54c1)"),
    ID_CARD_MERCHANT("id_card", "\u8eab\u4efd\u8bc1", "ct-idCard-merchant", "24\u5c0f\u65f6\u4e0b\u5355\u91cf(\u540c\u4e00\u8eab\u4efd\u8bc1\uff0c\u540c\u4e00\u5e97\u94fa)");

    private String strategyCode;
    private String strategyType;
    private String itemName;
    private String itemCode;

    private StrategyGroupEnum(String strategyCode, String strategyType, String itemCode, String itemName) {
        this.strategyCode = strategyCode;
        this.strategyType = strategyType;
        this.itemName = itemName;
        this.itemCode = itemCode;
    }

    public static List<StrategyGroupDto> getStrategyGroupList(String strategyType) {
        ArrayList list;
        ArrayList finalList = list = Lists.newArrayList();
        Arrays.stream(StrategyGroupEnum.values()).forEach(item -> finalList.add(item));
        Map<String, List<StrategyGroupEnum>> map = list.stream().collect(Collectors.groupingBy(StrategyGroupEnum::getStrategyCode));
        Map<String, String> codeNameMap = list.stream().collect(Collectors.toMap(StrategyGroupEnum::getStrategyCode, StrategyGroupEnum::getStrategyType, (l, r) -> r));
        ArrayList<StrategyGroupDto> dtoList = new ArrayList<StrategyGroupDto>();
        map.forEach((k, v) -> {
            ArrayList<StrategyItemDto> itemList = new ArrayList<StrategyItemDto>();
            v.forEach(item -> {
                if (StringUtils.equalsIgnoreCase((CharSequence)StrategyType.AHEAD_PREVENT_ORDER.getValue(), (CharSequence)strategyType) ? StringUtils.equals((CharSequence)item.getItemCode(), (CharSequence)ADDRESS_MOBILE.getItemCode()) || StringUtils.equals((CharSequence)item.getItemCode(), (CharSequence)OTHER_countTuiacid.getItemCode()) || StringUtils.equals((CharSequence)item.getItemCode(), (CharSequence)ADDRESS_INVALID.getItemCode()) || StringUtils.equals((CharSequence)item.getItemCode(), (CharSequence)MOBILE.getItemCode()) || StringUtils.equals((CharSequence)item.getItemCode(), (CharSequence)MOBILE_DUPLICATE_HIT.getItemCode()) : (StringUtils.equalsIgnoreCase((CharSequence)StrategyType.SHOT_ORDER.getValue(), (CharSequence)strategyType) ? StringUtils.equals((CharSequence)item.getItemCode(), (CharSequence)MOBILE_DUPLICATE_HIT.getItemCode()) || StringUtils.equals((CharSequence)item.getItemCode(), (CharSequence)ID_CARD_AGE.getItemCode()) || StringUtils.equals((CharSequence)item.getItemCode(), (CharSequence)ID_CARD_AREA.getItemCode()) || StringUtils.equals((CharSequence)item.getItemCode(), (CharSequence)ID_CARD_FORMAT.getItemCode()) : Strings.isNullOrEmpty((String)strategyType) && (StringUtils.equals((CharSequence)item.getItemCode(), (CharSequence)ID_CARD_AGE.getItemCode()) || StringUtils.equals((CharSequence)item.getItemCode(), (CharSequence)ID_CARD_AREA.getItemCode()) || StringUtils.equals((CharSequence)item.getItemCode(), (CharSequence)ID_CARD_FORMAT.getItemCode())))) {
                    return;
                }
                StrategyItemDto dto = new StrategyItemDto();
                dto.setItemCode(item.getItemCode());
                dto.setItemName(item.getItemName());
                itemList.add(dto);
            });
            if (CollectionUtils.isNotEmpty(itemList)) {
                StrategyGroupDto groupDto = new StrategyGroupDto();
                groupDto.setStrategyCode((String)k);
                groupDto.setStrategyType((String)codeNameMap.get(k));
                groupDto.setItemList(itemList);
                dtoList.add(groupDto);
            }
        });
        return dtoList;
    }

    public static Map<String, String> getCodeMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (StrategyGroupEnum sge : StrategyGroupEnum.values()) {
            map.put(sge.getItemCode(), sge.getStrategyCode());
        }
        return map;
    }

    public String getStrategyCode() {
        return this.strategyCode;
    }

    public void setStrategyCode(String strategyCode) {
        this.strategyCode = strategyCode;
    }

    public String getStrategyType() {
        return this.strategyType;
    }

    public void setStrategyType(String strategyType) {
        this.strategyType = strategyType;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemCode() {
        return this.itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }
}

