package com.qiho.center.api.dto.finance;

import com.qiho.center.api.dto.BaseDto;
import com.qiho.center.api.enums.finance.FinanceTypeEnum;
import com.qiho.center.api.enums.finance.FinanceOptTypeEnum;
import com.qiho.center.api.enums.finance.FinanceDetailStatusEnum;
import com.qiho.center.api.enums.finance.ParterTypeEnum;

import java.util.Date;

/** 资金流水对象
 * @author chensong
 * @create 2017-12-19 18:42
 **/
public class FinanceDetailDto extends BaseDto {

    private static final long serialVersionUID = -8203024587739515832L;
    /** 主键 */
    private Long id;

    /** 资金账户id */
    private Long financeId;

    private FinanceTypeEnum relationType;

    /** 关联的  商家/代理商 id */
    private Long relationId;

    /** 关联的 商家/代理商  名称 */
    private String name;

    /** 总收入 */
    private Long incomeTotal;

    /** 现金收入 */
    private Long incomeCash;

    /** 返点收入 */
    private Long incomeRebate;

    /** 总支出 */
    private Long expenditureTotal;

    /** 现金支出 */
    private Long expenditureCash;

    /** 返点支出 */
    private Long expenditureRebate;

    /** 操作员id */
    private Long operator;

    /** 操作类型 */
    private FinanceOptTypeEnum operatorType;


    /** 状态 */
    private FinanceDetailStatusEnum state;

    /** 备注 */
    private String remark;

    /** 合作商类型 */
    private ParterTypeEnum partnerType;

    /** 合作商交易号 */
    private String partnerTradeNo;

    /** 合作商返回状态 */
    private String partnerTradeState;

    /**
     * 调用第三方系统产生的交易号
     */
    private String financeTradeNo;

    /** 删除标识 */
    private Boolean deleted;

    /** 创建时间 */
    private Date gmtCreate;

    /** 修改时间 */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public FinanceTypeEnum getRelationType() {
        return relationType;
    }

    public void setRelationType(FinanceTypeEnum relationType) {
        this.relationType = relationType;
    }

    public Long getFinanceId() {
        return financeId;
    }

    public void setFinanceId(Long financeId) {
        this.financeId = financeId;
    }

    public Long getRelationId() {
        return relationId;
    }

    public void setRelationId(Long relationId) {
        this.relationId = relationId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getIncomeTotal() {
        return incomeTotal;
    }

    public void setIncomeTotal(Long incomeTotal) {
        this.incomeTotal = incomeTotal;
    }

    public Long getIncomeCash() {
        return incomeCash;
    }

    public void setIncomeCash(Long incomeCash) {
        this.incomeCash = incomeCash;
    }

    public Long getIncomeRebate() {
        return incomeRebate;
    }

    public void setIncomeRebate(Long incomeRebate) {
        this.incomeRebate = incomeRebate;
    }

    public Long getExpenditureTotal() {
        return expenditureTotal;
    }

    public void setExpenditureTotal(Long expenditureTotal) {
        this.expenditureTotal = expenditureTotal;
    }

    public Long getExpenditureCash() {
        return expenditureCash;
    }

    public void setExpenditureCash(Long expenditureCash) {
        this.expenditureCash = expenditureCash;
    }

    public Long getExpenditureRebate() {
        return expenditureRebate;
    }

    public void setExpenditureRebate(Long expenditureRebate) {
        this.expenditureRebate = expenditureRebate;
    }

    public Long getOperator() {
        return operator;
    }

    public void setOperator(Long operator) {
        this.operator = operator;
    }

    public FinanceOptTypeEnum getOperatorType() {
        return operatorType;
    }

    public void setOperatorType(FinanceOptTypeEnum operatorType) {
        this.operatorType = operatorType;
    }

    public FinanceDetailStatusEnum getState() {
        return state;
    }

    public void setState(FinanceDetailStatusEnum state) {
        this.state = state;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public ParterTypeEnum getPartnerType() {
        return partnerType;
    }

    public void setPartnerType(ParterTypeEnum partnerType) {
        this.partnerType = partnerType;
    }

    public String getFinanceTradeNo() {
        return financeTradeNo;
    }

    public void setFinanceTradeNo(String financeTradeNo) {
        this.financeTradeNo = financeTradeNo;
    }

    public String getPartnerTradeNo() {
        return partnerTradeNo;
    }

    public void setPartnerTradeNo(String partnerTradeNo) {
        this.partnerTradeNo = partnerTradeNo;
    }

    public String getPartnerTradeState() {
        return partnerTradeState;
    }

    public void setPartnerTradeState(String partnerTradeState) {
        this.partnerTradeState = partnerTradeState;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
