package com.qiho.center.api.enums.log;

/**
 * @author Wangpf
 * @description   对外订单导出日志记录类型枚举类
 * @date 2020/11/4 10:33 上午
 */
public enum OrderExportTypeEnum {

    NORMAL(0, "正常导出"),

    NOT_HIT_WHITE_IP(1, "未命中IP白名单");

    OrderExportTypeEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private final int type;

    private final String desc;

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
