package com.qiho.center.api.enums;


/**
 * ClassName: ErpErrorCodeEnum <br/>
 * Function: 返回给圆通物流的错误码枚举. <br/>
 * date: 2017年6月6日 下午4:05:02 <br/>
 *
 * @author chencheng
 * @version
 */
public enum YTOErrorCodeReturnEnum {
    /** 接口请求成功 */
    SUCCESS(true, "SUCCESS"),

    /** 签名验证失败 */
    SIGN_ERROR(false, "签名验证失败"),

    /** logistics_interface解码失败 */
    LOGISTICS_ERROR(false, "logistics_interface解码失败"),
    
    /** 客户编码校验失败 */
    CLIENTID_ERROR(false, "客户编码校验失败"),
    
    /** 操作类型不存在，无法判刑物流状态 */
    INFO_CONTENT_ERROR(false, "操作类型不存在，无法判刑物流状态"),

    /** 订单编号不存在 */
    TXLOGISTICID_NON_ERROR(false, "物流单号不存在"),
    
    /** 更新物流信息失败 */
    UPDATE_ERROR(false, "更新物流信息失败"),
    
    /** 其他原因 */
    OTHER_ERROR(false, "其他原因");

    /** 代码 */
    private Boolean code;

    /** 描述 */
    private String desc;

    private YTOErrorCodeReturnEnum(Boolean code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    
    /**
     * @return code
     */
    public Boolean getCode() {
        return code;
    }

    /**
     * @return desc
     */
    public String getDesc() {
        return desc;
    }
}
