package com.qiho.center.api.remoteservice.sms;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import com.qiho.center.api.dto.sms.MobileCodeDto;

/**
 * @author Wangpf
 * @description
 * @date 2020/7/6 5:06 下午
 */
@AdvancedFeignClient
public interface RemoteSmsCodeService {

    /**
     * 保存手机号对应的验证码
     *
     * @param mobileCodeDto
     * @return
     */
    boolean saveSms(MobileCodeDto mobileCodeDto);


    /**
     * 根据手机号获取最新的验证码
     *
     * @param mobile
     * @return
     */
    MobileCodeDto findLatestCodeByMobile(String mobile);

    /**
     *  统计手机号半小时的发送短信的次数
     *
     * @param mobile
     * @return
     */
    int countTimesWithInHalfHour(String mobile);

    /**
     * 过期code
     *
     * @param mobile
     * @return
     */
    int expireCode(String mobile, String code);

    /**
     * 给当前手机号的验证码增加一次校验次数
     *
     * @param mobile
     * @param code
     * @return
     */
    int addCheckTimeOnce(String mobile, String code);

    /**
     * 获取验证码校验的次数
     *
     * @param mobile
     * @param code
     * @return
     */
    Integer getCheckTimesByCode(String mobile, String code);
}
