package com.qiho.center.api.constant;

/**
 * Created by danke on 2017/9/14.
 * 商品相关常量配置
 */
public class ItemConstants {

    private ItemConstants() {
    }

    /**
     * 默认商品限购件数
     */
    public static final Integer DEFAULT_LIMIT_NUMBER = 3;



    /**
     * 商品扩展信息的常量
     */
    public static class ItemExtConstans{
        private ItemExtConstans() {
        }
        //扩展key,广告计划ids
        public static final String ADVERTIDS = "advertIds";
        //扩展key,阈值
        public static final String THRESHOLD = "threshold";
        //商品虚拟库存key
        public static final String VIRTUALSTOCK = "virtualStock";
        //商品进度条消耗比率,配置时的val都是整数
        public static final String CONSUMERATE = "consumeRate";
        //商品轮播场次的key
        public static final String BUYROUND = "buyRound";
        //商品轮播场次变更时间key
        public static final String ROUNDUPDATETIME = "roundUpdateTime";
        //商品倒计时循环时间
        public static final String COUNT_DOWN_CYCLE  = "countDownCycle";
        //推荐商品id,多个id逗号分隔
        public static final String MAIN_RECOMMEND_ITEM_ID = "mainRecommendItemId";
        // 收银台图片
        public static final String CASHIER_IMG = "cashierImg";

        /** 商品限购件数 */
        public static final String LIMIT_NUMBER = "limitNumber";

        /** 是否支持货到付款 key */
        public static final String SUPPORT_COD = "supportCOD";
    }
}
