package com.qiho.center.api.dto.account;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * Created by sunchangji on 2017/12/7.
 */
@Data
public class BaiqiAccountDto implements Serializable {

    private static final long serialVersionUID = -4314484220308941492L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 账户名称
     */
    private String account;

    /**
     * 关联的 商家/代理上信息
     */
    private List<AccountRelationDto> relationDtoList;

    /**
     * 账户类型 @See BaiqiAccountTypeEnum
     */
    private Integer accountType;

    /**
     * 主账号id
     */
    private Long parentId;

    /**
     * 密码
     */
    private String pwd;

    /**
     * 账户状态 @See BaiqiAccountStatusEnum
     */
    private Integer state;

    /**
     * 子账号菜单id集
     */
    private String menuIds;

}
