package com.qiho.center.api.dto.component;

import com.qiho.center.api.dto.BaseDto;
import com.qiho.center.api.enums.component.ComponentTypeEnum;

import java.util.Date;

/** 组件Dto
 * @author chensong
 * @create 2018-07-24
 */
public class ComponentDto extends BaseDto {

    /** 主键id */
    private Long id;

    /** 组件名 */
    private String componentName;

    /** 组件类型 */
    private ComponentTypeEnum componentType;

    /** 预览图 */
    private String image;

    /** 组件代码文件地址 */
    private String codeUrl;

    /** 组件代码文件的Md5摘要 */
    private String codeMd5;

    /** 组件的配置项 */
    private String configParam;

    /** 最后操作人员 */
    private String operator;

    /** 删除标识 */
    private Boolean deleted;

    /** 创建时间 */
    private Date gmtCreate;

    /** 修改时间 */
    private Date gmtModified;

    /**
     * 是否需要隐藏
     */
    private Integer isHidden;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getComponentName() {
        return componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public ComponentTypeEnum getComponentType() {
        return componentType;
    }

    public void setComponentType(ComponentTypeEnum componentType) {
        this.componentType = componentType;
    }

    public String getImage() {
        return image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getCodeUrl() {
        return codeUrl;
    }

    public void setCodeUrl(String codeUrl) {
        this.codeUrl = codeUrl;
    }

    public String getCodeMd5() {
        return codeMd5;
    }

    public void setCodeMd5(String codeMd5) {
        this.codeMd5 = codeMd5;
    }

    public String getConfigParam() {
        return configParam;
    }

    public void setConfigParam(String configParam) {
        this.configParam = configParam;
    }

    public String getOperator() {
        return operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public Boolean getDeleted() {
        return deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Integer getIsHidden() {
        return isHidden;
    }

    public void setIsHidden(Integer isHidden) {
        this.isHidden = isHidden;
    }
}
