package com.qiho.center.api.dto.finance;

import com.qiho.center.api.dto.shop.AbstractShopDto;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Wangpf
 * @description 商家财务信息详情Dto
 * @date 2020/9/24 4:41 下午
 */
@Data
public class ShopFinanceDetailDto extends AbstractShopDto implements Serializable {

    /**
     * 主键Id
     */
    private Long id;

    /**
     * 开户公司
     */
    private String accountCompany;

    /**
     * 开户银行
     */
    private String accountBank;

    /**
     * 银行账号
     */
    private String bankAccount;

    /**
     * 收款信息证明
     */
    private String gatheringInformationUrl;

    /**
     * 商家资质信息
     */
    private String businessLicense;

    /**
     * 审核状态
     */
    private Integer auditStatus;

    /**
     * 备注
     */
    private String remark;

    /**
     * 拒绝的原因
     */
    private String rejectReason;
}
