package com.qiho.center.api.enums;

import java.util.stream.Stream;

/**
 * 快递鸟物流状态
 * @author: wangjin
 * @create 2018-06-12 09:23
 **/
public enum ExpressBirdLogisticsStatusEnum {

    /**接单 */
    ACCEPT("1","已揽收"),
    /** 在途 */
    UNDER_WAY("2","在途中"),
    /** 派件 */
    ARRIVE_CITY("201","到达派件城市"),
    SENT_SCAN("202", "派件中"),
    ARRIVED_DAK("211", "已放入快递柜或驿站"),

    /** 签收成功 */
    SUCCESS("3", "已签收"),
    NORMAL_SIGN("301", "正常签收"),
    FINAL_SIGN( "302", "派件异常，最终签收"),
    PROXY_SIGN( "304", "代收签收"),
    DAK_PROXY_SIGN("311", "快递柜代收签收"),

    /** 签收失败 */
    TROUBLE("4","问题件"),
    NO_INFO("401","发货无信息"),
    OVERTIME_SIGN("402","超时未签收"),
    OVERTIME_UPDATE("403","超时未更新"),
    SEND_EXCEPTION("405", "派件异常"),
    OVERTIME_NOT_TAKE("412", "快递柜或驿站超时未取"),

    /** 拒签 */
    REJECTED("404","异常-拒收（退件）"),

    /** 退件成功 */
    RETURN_SIGN("406", "退货签收"),

    /** 退回中 */
    SEND_BACK("407", "退货未签收");

    private String state;

    private String desc;

    ExpressBirdLogisticsStatusEnum(String state,String desc){
        this.state = state;
        this.desc = desc;
    }

    public static ExpressBirdLogisticsStatusEnum getByState(String state){
        return Stream.of(ExpressBirdLogisticsStatusEnum.values())
                .filter(item -> item.getState().equals(state))
                .findFirst().orElse(null);
    }

    public String getState(){
        return state;
    }

    public String getDesc(){
        return desc;
    }

}
