package com.qiho.center.api.enums.ShotOrder;

import com.qiho.center.api.dto.OrderSnapshotDto;
import com.qiho.center.api.dto.StrategyRuleDto;
import com.qiho.center.api.dto.resultbase.ResultBase;
import org.apache.commons.lang.StringUtils;

/**
 * Created by danke on 2017/6/21.
 * 统一规则校验接口,可用于枚举中定义,也可用于复杂链路定义
 */
public interface ShotOrderValute {

    ResultBase<Boolean> valuteOrderByQuery(String a, Object b);

    /**
     * 基本校验,只用于数字之间的比较的校验
     * @param threshold
     * @param hopeVal
     * @return
     */
    static ResultBase<Boolean> baseParamsCheck(String threshold,Object hopeVal){
        if (StringUtils.isBlank(threshold) || !StringUtils.isNumeric(threshold)
                || null == hopeVal || !StringUtils.isNumeric(String.valueOf(hopeVal))){
            return ResultBase.errorReturn("参数非法,请检查策略规则配置是否有误");
        }
        return ResultBase.rightReturn(Boolean.TRUE);
    }

    /**
     * 默认方法,只有复杂链路实现类会调用此方法,需要自己实现逻辑
     * @return
     */
    default ResultBase<Boolean> valuteCostomByQuery(OrderSnapshotDto orderSnapshotDto, StrategyRuleDto strategyRuleDto){
        return null;
    }

}
