package com.qiho.center.api.enums.purchase;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.stream.Stream;

/**
 * 弹层地址类型
 *
 * @author peanut.huang
 * @date 2020/7/13
 * @since JDK 1.8
 */
@Getter
public enum LayerUrlTypeEnum {

    /**
     *
     */
    GLOBAL(1, "全局配置定制url"),

    GLOBAL_JF(2, "全局配置加粉弹窗url"),

    GLOBAL_BIG(3, "全局配置大字报弹窗url"),

    DEFINED(4, "组件自定义的url");

    ;

    private Integer     type;
    private String      desc;

    LayerUrlTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    /**
     * 根据类型查询
     *
     * @param type
     * @return
     */
    public static LayerUrlTypeEnum findByType(String type){
        if(StringUtils.isBlank(type)){
            return null;
        }

        return Stream.of(LayerUrlTypeEnum.values())
            .filter(e -> e.toString().equals(type))
            .findFirst()
            .orElse(null);
    }
}
