package com.qiho.center.api.params.discount;

import com.qiho.center.api.enums.discount.DiscountTypeEnum;
import com.qiho.center.api.enums.discount.DiscountUseTermTypeEnum;

import java.io.Serializable;

/**
 * 订单优惠信息的参数
 *
 * @author chensong
 * @create 2018-09-04
 */
public class OrderDiscountParam implements Serializable {

    private static final long serialVersionUID = -6865637670589184682L;

    /** 优惠类型 */
    private DiscountTypeEnum discountType;

    /** 优惠值 */
    private Integer discountValue;

    /** 优惠使用条件 */
    private DiscountUseTermTypeEnum useType;

    /** 优惠使用的阈值 */
    private Integer useThreshold;

    /** 备注 */
    private String remark;

    public DiscountTypeEnum getDiscountType() {
        return discountType;
    }

    public void setDiscountType(DiscountTypeEnum discountType) {
        this.discountType = discountType;
    }

    public Integer getDiscountValue() {
        return discountValue;
    }

    public void setDiscountValue(Integer discountValue) {
        this.discountValue = discountValue;
    }

    public DiscountUseTermTypeEnum getUseType() {
        return useType;
    }

    public void setUseType(DiscountUseTermTypeEnum useType) {
        this.useType = useType;
    }

    public Integer getUseThreshold() {
        return useThreshold;
    }

    public void setUseThreshold(Integer useThreshold) {
        this.useThreshold = useThreshold;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
