package com.qiho.center.api.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

import com.alibaba.fastjson.JSONObject;

/**
 * Created by Zhangshun on 2018/3/21,13:30:02.
 */
public class BizLog {

    private static final Logger LOGGER = LoggerFactory.getLogger("innerLog");

    private BizLog() {
        throw new IllegalStateException("Utility class");
    }

    // =====================
    // info
    // =====================

    /**
     * log日志打印
     *
     * 因运维同学要求把innerLog日志打成json格式
     *
     * @param format           日志信息，包含占位符
     * @param arguments        占位符替换参数集
     * @author peanut.huang
     * @date 2018.04.26
     */
    public static void log(String format, Object... arguments) {

        // 格式化
        FormattingTuple tuple = MessageFormatter.arrayFormat(format, arguments);

        // json化
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("message", tuple.getMessage());

        // 打印
        LOGGER.info(jsonObject.toJSONString());
    }

    public static void log(String msg, Throwable t) {
        LOGGER.info(msg, t);
    }
}
