package com.qiho.center.api.util;

import com.google.common.collect.Lists;
import com.qiho.center.api.exception.QihoException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.security.MessageDigest;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Created by danke on 2017/7/20.
 */
public class MD5Facade {

    private static Logger logger = LoggerFactory.getLogger(MD5Facade.class);

    private MD5Facade(){}

    /**
     * 针对NowPay目前统一的MD5签名方式：key1=value1&key2=value2....keyn=valuen&securityKeySignature  进行MD5
     * @param dataMap  --需要参与MD5签名的数据
     * @param securityKey    --密钥
     * @return
     */
    public static boolean validateFormDataParamMD5(Map<String,String> dataMap, String securityKey, String currentSignature){
        if(dataMap == null) return false;

        Set<String> keySet = dataMap.keySet();
        List<String> keyList = Lists.newArrayList(keySet);
        Collections.sort(keyList);

        StringBuilder toMD5StringBuilder = new StringBuilder();
        for(String key : keyList){
            String value = dataMap.get(key);

            if(value != null && value.length()>0){
                toMD5StringBuilder.append(key+"="+ value+"&");
            }
        }

        try{
            String securityKeyMD5 = MD5.md5(securityKey,"");
            toMD5StringBuilder.append(securityKeyMD5);

            String toMD5String = toMD5StringBuilder.toString();

            String actualMD5Value = MD5.md5(toMD5String,"");

            return actualMD5Value.equals(currentSignature);
        }catch (Exception ex){
            return false;
        }
    }

    /**
     * 针对NowPay目前统一的MD5签名方式：key1=value1&key2=value2....keyn=valuen&securityKeySignature  进行MD5
     * <p>要先对Key进行按字典升序排序
     * @param dataMap  -- 数据
     * @param securityKey    --密钥
     * @param charset
     * @return
     */
    public static String getFormDataParamMD5(Map<String,String> dataMap,String securityKey,String charset){
        if(dataMap == null) return null;

        Set<String> keySet = dataMap.keySet();
        List<String> keyList = Lists.newArrayList(keySet);
        Collections.sort(keyList);

        StringBuilder toMD5StringBuilder = new StringBuilder();
        for(String key : keyList){
            String value = dataMap.get(key);

            if(value != null && value.length()>0){
                toMD5StringBuilder.append(key+"="+ value+"&");
            }
        }

        try{
            String securityKeyMD5 = MD5.md5(securityKey,charset);
            toMD5StringBuilder.append(securityKeyMD5);

            String toMD5String = toMD5StringBuilder.toString();
            logger.info("待MD5签名字符串 = {}",toMD5String);

            String lastMD5Result = MD5.md5(toMD5String,charset);
            logger.info("MD5签名后字符串 = {}",lastMD5Result);

            return lastMD5Result;
        }catch (Exception ex){
            //ignore
            return "";
        }
    }

    public static class MD5 {

        private MD5(){}
        /**
         * MD5方法
         *
         * @param text 明文
         * @param charset 密钥
         * @return 密文
         * @throws Exception
         */
        public static String md5(String text, String charset){
            try{
                String newCharSet = StringUtils.isBlank(charset) ? "UTF-8" : charset;
                byte[] bytes = text.getBytes(newCharSet);
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                messageDigest.update(bytes);
                bytes = messageDigest.digest();
                StringBuilder sb = new StringBuilder();
                for(int i = 0; i < bytes.length; i ++)
                {
                    if((bytes[i] & 0xff) < 0x10)
                    {
                        sb.append("0");
                    }
                    sb.append(Long.toString(bytes[i] & 0xff, 16));
                }
                return sb.toString().toLowerCase();
            }catch(Exception e){
                logger.error("MD5Facade call md5 error",e);
                throw new QihoException();
            }
        }

        /**
         * MD5验证方法
         *
         * @param text 明文
         * @param charset 字符编码
         * @param md5 密文
         * @return true/false
         * @throws Exception
         */
        public static boolean verify(String text, String charset, String md5){
            String md5Text = md5(text, charset);
            return md5Text.equalsIgnoreCase(md5);

        }
    }
}
