package com.qiho.center.api.dto.trading.record;

import com.qiho.center.api.enums.PayTypeEnum;
import com.qiho.center.api.enums.trading.statistics.CloseStatusEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Wangpf
 * @description 这个dto用来和 {@link ShopTradingRecordDto } 区分 closeStatus等字段类型和 对应entity 保持一直
 * @date 2020/9/11 5:44 下午
 */
@Data
public class ShopTradingRecordDtoOrigin implements Serializable {

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 店铺Id
     */
    private Long shopId;

    /**
     * 订单Id
     */
    private String orderId;

    /**
     * 商品Id
     */
    private Long itemId;

    /**
     * 订单状态
     */
    private String orderStatus;

    /**
     * 售后的状态
     */
    private Integer afterSaleStatus;

    /**
     * 支付类型 {@link PayTypeEnum}
     */
    private String payType;

    /**
     * 订单金额
     */
    private Integer orderAmt;

    /**
     * 订单退款金额
     */
    private Integer orderFundAmt;

    /**
     * 手续费，单位：分
     */
    private Integer poundageAmt;

    /**
     * 手续费率
     */
    private String poundageRate;

    /**
     * 结算状态，{@link CloseStatusEnum#getCode()}
     */
    private Integer closeStatus;

    /**
     * 订单结算时间
     */
    private String closeTime;

    /**
     * 订单结算金额
     */
    private Integer closeAmt;

    /**
     * 订单的创建时间
     */
    private String orderCreateTime;

    /**
     * 创建时间
     */
    private String gmtCreate;

    /**
     * 修改时间
     */
    private String gmtModified;

    /**
     * 订单未关闭的原因 {@link com.qiho.center.api.enums.trading.record.NotCloseReasonEnum}
     */
    private Integer notCloseReason;

    /**
     * 外部流水号
     */
    private String externalSerialNumber;
}
