package com.qiho.center.api.enums.ShotOrder;

import org.apache.commons.lang.StringUtils;

/**
 * Created by danke on 2017/6/21.
 * 定义订单校验维度名称及详细介绍,订单基本属性如果需要复杂校验的,配上key,key用于获取自定义执行action
 */
public enum ShotOrderFieldEnum {

    TUIA_ID(0,"推啊id","tuiaId",""),

    PLACE_ORDER_TIME(1,"页面停留时长(秒)","remainTime",""),

    LEAVE_WORDS(2,"用户留言","message",""),

    CHANNEL_ID(3,"结算7hoId","channelId",""),

    COUNT_CHANNEL_ID(4,"统计7hoId","countChannelId",""),
    
    COUNT_QUANTITY(5,"订单件数","quantity",""),
    
    CONSUMER_NAME(6,"收件人姓名","consumerName",""),
    
    ADDRESS(7,"详细地址","info-address",""),

    SKU_NO(8,"货号","itemNo",""),

    ITEM_ID(9,"商品id","itemId",""),

    ID_CARD_AGE(10,"身份证年龄","age-idCard",""),

    ID_CARD_AREA(11,"身份证区号","area-idCard",""),

    ID_CARD_FORMAT(13,"身份证格式","format-idCard",""),

    REPEAT_ORDER_PHONE(101,"下单量(手机号统计)","count-mobile",ShotOrderConstant.StrategyAction.REPEAT_PLACE_ORDER),

    REPEAT_ORDER_TUIAID(102,"下单量(推啊id统计)","count-tuiaId",ShotOrderConstant.StrategyAction.REPEAT_PLACE_ORDER),

    ADRESS_LENGTH(103,"详细地址的长度","address",ShotOrderConstant.StrategyAction.ADRESS_LENGTH),


    // add by peanut.huang on 2018.03.15
    REPEAT_ORDER_IP(104,"下单量(ip统计)","count-ip",ShotOrderConstant.StrategyAction.REPEAT_PLACE_ORDER),

    PHONE_STATUS(105,"下单手机号状态","mobile",ShotOrderConstant.StrategyAction.ORDER_MOBILE),

    INVALID_ADDRESS(106,"地址有效性","invalid-address",ShotOrderConstant.StrategyAction.INVALID_ADDRESS),

    REPEAT_ORDER_PHONE_ITEM(107,"下单量(同一手机号同一商品)","ct-phone-item",ShotOrderConstant.StrategyAction.COUNT_PHONT_ITEM),

    REPEAT_ORDER_PHONE_MERCHANT(108,"下单量(同一手机号同一商家)","ct-phone-merchant",ShotOrderConstant.StrategyAction.COUNT_PHONE_MERCHANT),

    IP_MOBILE_ADDRESS_CHECK(109,"IP归属地手机号归属地收货地址校验","ip-mobile-address-check",ShotOrderConstant.StrategyAction.IP_MOBILE_ADDRESS_CHECK),

    REPEAT_ORDER_TUIACID(110, "下单量(推啊用户id统计)","count-tuiacid",ShotOrderConstant.StrategyAction.REPEAT_ORDER_TUIACID),

    MOBILE_DUPLICATE_HIT(111, "手机号多次命中现有规则", "mobile-duplicate-hit", ShotOrderConstant.StrategyAction.MOBILE_DUPLICATE_HIT),

    DELIVERY_REGION_EXCLUSIVE(112, "收获地址省份和城市", "delivery-region", ShotOrderConstant.StrategyAction.DELIVERY_REGION_EXCLUSIVE),

    ID_CARD_COUNT(113, "下单量(身份证号统计)", "count-idCard", ShotOrderConstant.StrategyAction.ID_CARD_COUNT),

    ID_CARD_ITEM(114, "下单量(同一身份证，同一商品)", "ct-idCard-item", ShotOrderConstant.StrategyAction.ID_CARD_ITEM),

    ID_CARD_MERCHANT(115, "下单量(同一身份证，同一店铺)", "ct-idCard-merchant", ShotOrderConstant.StrategyAction.ID_CARD_MERCHANT),

    ID_CARD_NAME(116, "六律-身份证姓名匹配", "name-idCard", ShotOrderConstant.StrategyAction.ID_CARD_NAME),

    MOBILE_QUALIFICATION(117, "六律-手机号下单资格", "mobile-order-qualification", ShotOrderConstant.StrategyAction.MOBILE_QUALIFICATION),

    KAISU_ID_CARD_NAME(118, "开速-身份证姓名匹配", "kaisu-name-idCard", ShotOrderConstant.StrategyAction.KAISU_ID_CARD_NAME),

    MOBILE_FLOW_PACKET_CALIBRATION(119, "六律流量包办理校验", "ll-flow-packet-calibration", ShotOrderConstant.StrategyAction.MOBILE_FLOW_PACKET_CALIBRATION)
    ;



    //code之后作为判断数据类型的值,提供前段渲染做判断
    private int code;
    private String msg;
    private String val;//订单信息中的字段名
    private String key;//复杂链路的map调用key

    /**
     * @param code
     * @return
     */
    public static ShotOrderFieldEnum fromStatus(Integer code) {
        if (code==null) {
            return null;
        }
        for (ShotOrderFieldEnum shotOrderFieldEnum : ShotOrderFieldEnum.values()) {
            if (shotOrderFieldEnum.getCode() == code) {
                return shotOrderFieldEnum;
            }
        }
        return null;
    }

    /**
     * 通过val值去获取对应的枚举
     * @param val
     */
    public static ShotOrderFieldEnum fromVal(String val){
        if(StringUtils.isBlank(val)){
            return null;
        }
        for (ShotOrderFieldEnum shotOrderFieldEnum : ShotOrderFieldEnum.values()) {
            if (shotOrderFieldEnum.getVal().equals(val)) {
                return shotOrderFieldEnum;
            }
        }
        return null;
    }



    ShotOrderFieldEnum(int code, String msg, String val, String key) {
        this.code = code;
        this.msg = msg;
        this.val = val;
        this.key = key;
    }

    public int getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }

    public String getVal() {
        return val;
    }

    public String getKey() {
        return key;
    }
}
