package com.qiho.center.api.enums.area.code;

import com.qiho.center.api.enums.area.AreaCodeEnumerable;

import java.util.Arrays;

public enum AreaCodeJSEnum implements AreaCodeEnumerable {
    CODE_320000("320000", "江苏省"),
    CODE_320100("320100", "江苏省南京市"),
    CODE_320101("320101", "江苏省南京市市辖区"),
    CODE_320102("320102", "江苏省南京市玄武区"),
    CODE_320103("320103", "江苏省南京市白下区"),
    CODE_320104("320104", "江苏省南京市秦淮区"),
    CODE_320105("320105", "江苏省南京市建邺区"),
    CODE_320106("320106", "江苏省南京市鼓楼区"),
    CODE_320107("320107", "江苏省南京市下关区"),
    CODE_320111("320111", "江苏省南京市浦口区"),
    CODE_320112("320112", "江苏省南京市大厂区"),
    CODE_320113("320113", "江苏省南京市栖霞区"),
    CODE_320114("320114", "江苏省南京市雨花台区"),
    CODE_320121("320121", "江苏省南京市江宁县"),
    CODE_320122("320122", "江苏省南京市江浦县"),
    CODE_320123("320123", "江苏省南京市六合县"),
    CODE_320124("320124", "江苏省南京市溧水县"),
    CODE_320125("320125", "江苏省南京市高淳县"),
    CODE_320200("320200", "江苏省无锡市"),
    CODE_320201("320201", "江苏省无锡市市辖区"),
    CODE_320202("320202", "江苏省无锡市崇安区"),
    CODE_320203("320203", "江苏省无锡市南长区"),
    CODE_320204("320204", "江苏省无锡市北塘区"),
    CODE_320211("320211", "江苏省无锡市郊区"),
    CODE_320281("320281", "江苏省无锡市江阴市"),
    CODE_320282("320282", "江苏省无锡市宜兴市"),
    CODE_320283("320283", "江苏省无锡市锡山市"),
    CODE_320300("320300", "江苏省徐州市"),
    CODE_320301("320301", "江苏省徐州市市辖区"),
    CODE_320302("320302", "江苏省徐州市鼓楼区"),
    CODE_320303("320303", "江苏省徐州市云龙区"),
    CODE_320304("320304", "江苏省徐州市九里区"),
    CODE_320305("320305", "江苏省徐州市贾汪区"),
    CODE_320311("320311", "江苏省徐州市泉山区"),
    CODE_320321("320321", "江苏省徐州市丰县"),
    CODE_320322("320322", "江苏省徐州市沛县"),
    CODE_320323("320323", "江苏省徐州市铜山县"),
    CODE_320324("320324", "江苏省徐州市睢宁县"),
    CODE_320381("320381", "江苏省徐州市新沂市"),
    CODE_320382("320382", "江苏省徐州市邳州市"),
    CODE_320400("320400", "江苏省常州市"),
    CODE_320401("320401", "江苏省常州市市辖区"),
    CODE_320402("320402", "江苏省常州市天宁区"),
    CODE_320404("320404", "江苏省常州市钟楼区"),
    CODE_320405("320405", "江苏省常州市戚墅堰区"),
    CODE_320411("320411", "江苏省常州市郊区"),
    CODE_320481("320481", "江苏省常州市溧阳市"),
    CODE_320482("320482", "江苏省常州市金坛市"),
    CODE_320483("320483", "江苏省常州市武进市"),
    CODE_320500("320500", "江苏省苏州市"),
    CODE_320501("320501", "江苏省苏州市市辖区"),
    CODE_320502("320502", "江苏省苏州市沧浪区"),
    CODE_320503("320503", "江苏省苏州市平江区"),
    CODE_320504("320504", "江苏省苏州市金阊区"),
    CODE_320511("320511", "江苏省苏州市郊区"),
    CODE_320581("320581", "江苏省苏州市常熟市"),
    CODE_320582("320582", "江苏省苏州市张家港市"),
    CODE_320583("320583", "江苏省苏州市昆山市"),
    CODE_320584("320584", "江苏省苏州市吴江市"),
    CODE_320585("320585", "江苏省苏州市太仓市"),
    CODE_320586("320586", "江苏省苏州市吴县市"),
    CODE_320600("320600", "江苏省南通市"),
    CODE_320601("320601", "江苏省南通市市辖区"),
    CODE_320602("320602", "江苏省南通市崇川区"),
    CODE_320611("320611", "江苏省南通市港闸区"),
    CODE_320621("320621", "江苏省南通市海安县"),
    CODE_320623("320623", "江苏省南通市如东县"),
    CODE_320681("320681", "江苏省南通市启东市"),
    CODE_320682("320682", "江苏省南通市如皋市"),
    CODE_320683("320683", "江苏省南通市通州市"),
    CODE_320684("320684", "江苏省南通市海门市"),
    CODE_320700("320700", "江苏省连云港市"),
    CODE_320701("320701", "江苏省连云港市市辖区"),
    CODE_320703("320703", "江苏省连云港市连云区"),
    CODE_320704("320704", "江苏省连云港市云台区"),
    CODE_320705("320705", "江苏省连云港市新浦区"),
    CODE_320706("320706", "江苏省连云港市海州区"),
    CODE_320721("320721", "江苏省连云港市赣榆县"),
    CODE_320722("320722", "江苏省连云港市东海县"),
    CODE_320723("320723", "江苏省连云港市灌云县"),
    CODE_320724("320724", "江苏省连云港市灌南县"),
    CODE_320800("320800", "江苏省淮阴市"),
    CODE_320801("320801", "江苏省淮阴市市辖区"),
    CODE_320802("320802", "江苏省淮阴市清河区"),
    CODE_320811("320811", "江苏省淮阴市清浦区"),
    CODE_320821("320821", "江苏省淮阴市淮阴县"),
    CODE_320826("320826", "江苏省淮阴市涟水县"),
    CODE_320829("320829", "江苏省淮阴市洪泽县"),
    CODE_320830("320830", "江苏省淮阴市盱眙县"),
    CODE_320831("320831", "江苏省淮阴市金湖县"),
    CODE_320882("320882", "江苏省淮阴市淮安市"),
    CODE_320900("320900", "江苏省盐城市"),
    CODE_320901("320901", "江苏省盐城市市辖区"),
    CODE_320902("320902", "江苏省盐城市城区"),
    CODE_320921("320921", "江苏省盐城市响水县"),
    CODE_320922("320922", "江苏省盐城市滨海县"),
    CODE_320923("320923", "江苏省盐城市阜宁县"),
    CODE_320924("320924", "江苏省盐城市射阳县"),
    CODE_320925("320925", "江苏省盐城市建湖县"),
    CODE_320928("320928", "江苏省盐城市盐都县"),
    CODE_320981("320981", "江苏省盐城市东台市"),
    CODE_320982("320982", "江苏省盐城市大丰市"),
    CODE_321000("321000", "江苏省扬州市"),
    CODE_321001("321001", "江苏省扬州市市辖区"),
    CODE_321002("321002", "江苏省扬州市广陵区"),
    CODE_321011("321011", "江苏省扬州市郊区"),
    CODE_321023("321023", "江苏省扬州市宝应县"),
    CODE_321027("321027", "江苏省扬州市邗江县"),
    CODE_321081("321081", "江苏省扬州市仪征市"),
    CODE_321084("321084", "江苏省扬州市高邮市"),
    CODE_321088("321088", "江苏省扬州市江都市"),
    CODE_321100("321100", "江苏省镇江市"),
    CODE_321101("321101", "江苏省镇江市市辖区"),
    CODE_321102("321102", "江苏省镇江市京口区"),
    CODE_321111("321111", "江苏省镇江市润州区"),
    CODE_321121("321121", "江苏省镇江市丹徒县"),
    CODE_321181("321181", "江苏省镇江市丹阳市"),
    CODE_321182("321182", "江苏省镇江市扬中市"),
    CODE_321183("321183", "江苏省镇江市句容市"),
    CODE_321200("321200", "江苏省泰州市"),
    CODE_321201("321201", "江苏省泰州市市辖区"),
    CODE_321202("321202", "江苏省泰州市海陵区"),
    CODE_321203("321203", "江苏省泰州市高港区"),
    CODE_321281("321281", "江苏省泰州市兴化市"),
    CODE_321282("321282", "江苏省泰州市靖江市"),
    CODE_321283("321283", "江苏省泰州市泰兴市"),
    CODE_321284("321284", "江苏省泰州市姜堰市"),
    CODE_321300("321300", "江苏省宿迁市"),
    CODE_321301("321301", "江苏省宿迁市市辖区"),
    CODE_321302("321302", "江苏省宿迁市宿城区"),
    CODE_321321("321321", "江苏省宿迁市宿豫县"),
    CODE_321322("321322", "江苏省宿迁市沭阳县"),
    CODE_321323("321323", "江苏省宿迁市泗阳县"),
    CODE_321324("321324", "江苏省宿迁市泗洪县"),;
    /** 代码 */
    private String code;

    /** 描述 */
    private String desc;

    AreaCodeJSEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    @Override
    public boolean isExist(String code) {
        return Arrays.stream(values()).filter(v -> v.code.equals(code)).findFirst().isPresent();
    }
}
